/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.schema.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.schema.registry.client.AutocompletionAgent;
import org.apache.ranger.services.schema.registry.client.SchemaRegistryResourceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceSchemaRegistry
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceSchemaRegistry.class);

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public HashMap<String, Object> validateConfig() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        LOG.debug("==> RangerServiceSchemaRegistry.validateConfig({})", (Object)this.serviceName);
        if (this.configs != null) {
            try {
                AutocompletionAgent autocompletionAgent = new AutocompletionAgent(this.serviceName, this.configs);
                ret = autocompletionAgent.connectionTest();
            }
            catch (Exception e) {
                LOG.error("<== RangerServiceSchemaRegistry.validateConfig Error:{}", (Object)String.valueOf(e));
                throw e;
            }
        }
        LOG.debug("<== RangerServiceSchemaRegistry.validateConfig({}): ret={}", (Object)this.serviceName, ret);
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        LOG.debug("==> RangerServiceSchemaRegistry.lookupResource({})", (Object)this.serviceName);
        if (this.configs != null) {
            AutocompletionAgent autocompletionAgent = new AutocompletionAgent(this.serviceName, this.configs);
            ret = SchemaRegistryResourceMgr.getSchemaRegistryResources(this.serviceName, this.configs, context, autocompletionAgent);
        }
        LOG.debug("<== RangerServiceSchemaRegistry.lookupResource({}): ret={}", (Object)this.serviceName, ret);
        return ret;
    }
}

