/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.utils;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;

public class S3Utils {
    private static final Logger LOG = LoggerFactory.getLogger(S3Utils.class);
    private static final int BUCKET_REGION_CACHE_SIZE = 300;
    private static final Map<String, String> bucketRegionCache = Collections.synchronizedMap(new LinkedHashMap<String, String>(300, 1.1f, true){
        private static final long serialVersionUID = 23453L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 300;
        }
    });

    public static String getBucketNameFromHost(String host) {
        LOG.debug("Parsing bucket name from host: {}", (Object)host);
        String[] parts = host.split("\\.");
        if (parts.length > 0) {
            return parts[0];
        }
        return null;
    }

    public static String truncateBucketNameFromPath(String path, String bucketName) {
        path = path.startsWith("/") ? path.substring(1) : path;
        path = path.startsWith(bucketName) ? path.substring(bucketName.length()) : path;
        return path.startsWith("/") ? path.substring(1) : path;
    }

    public static String lookupRegionFromCache(String bucketName) {
        Preconditions.checkNotNull((Object)bucketName, (Object)"BucketName must be provided");
        return bucketRegionCache.get(bucketName);
    }

    public static void updateBucketToRegionCache(String bucketName, String regionName) {
        Preconditions.checkNotNull((Object)bucketName, (Object)"BucketName must be specified");
        Preconditions.checkNotNull((Object)regionName, (Object)"RegionName must be specified");
        bucketRegionCache.put(bucketName, regionName);
    }

    public static AwsServiceException extractAwsServiceException(Throwable excp) {
        AwsServiceException amazonServiceException = null;
        for (Throwable current = excp; current != null; current = current.getCause()) {
            if (!(current instanceof AwsServiceException)) continue;
            amazonServiceException = (AwsServiceException)current;
            break;
        }
        return amazonServiceException;
    }
}

