/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.utils;

import com.amazonaws.util.EC2MetadataUtils;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.raz.s3.lib.utils.S3Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;

public class S3RegionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(S3RegionUtils.class);
    private static final String US_EAST_1 = "us-east-1";
    private static final String US_GOV_WEST_1 = "us-gov-west-1";
    private static final String GS_REGION = "gs-region";
    private static final String GS_STORAGE_ENDPOINT = "https://storage.googleapis.com";
    private static final String DETERMINED_REGION_FOR_S3_CLIENT;

    public static String lookupRegion(String bucketName, AwsCredentialsProvider credentialsProvider, ApacheHttpClient.Builder awsConf, String forceRegionLookup) throws SdkClientException, AwsServiceException {
        if (!StringUtils.isBlank((CharSequence)forceRegionLookup) && forceRegionLookup.toUpperCase(Locale.US).equals("GS")) {
            LOG.debug("Force bucket region lookup using google's service endpoint");
            return S3RegionUtils.getBucketLocationFromAWS(bucketName, credentialsProvider, awsConf, GS_REGION);
        }
        if (StringUtils.isBlank((CharSequence)forceRegionLookup) && DETERMINED_REGION_FOR_S3_CLIENT != null) {
            LOG.debug("Determined region used for bucket region lookup : {}", (Object)DETERMINED_REGION_FOR_S3_CLIENT);
            return S3RegionUtils.getBucketLocationFromAWS(bucketName, credentialsProvider, awsConf, DETERMINED_REGION_FOR_S3_CLIENT);
        }
        LOG.info("Using Fallback region lookup with forceLookup value: {}", (Object)forceRegionLookup);
        if (StringUtils.isBlank((CharSequence)forceRegionLookup)) {
            throw new IllegalArgumentException(String.format("Please set 'ranger.raz.force.s3.region.lookup' property to a valid value, one of 'GOV', 'NON-GOV', or 'FALLBACK'. Current value: %s", forceRegionLookup));
        }
        switch (forceRegionLookup.toUpperCase(Locale.US)) {
            case "GOV": {
                LOG.debug("Force bucket region lookup using us-gov-west-1");
                return S3RegionUtils.getBucketLocationFromAWS(bucketName, credentialsProvider, awsConf, US_GOV_WEST_1);
            }
            case "NON-GOV": {
                LOG.debug("Force bucket region lookup using us-east-1");
                return S3RegionUtils.getBucketLocationFromAWS(bucketName, credentialsProvider, awsConf, US_EAST_1);
            }
            case "FALLBACK": {
                LOG.debug("Force bucket region lookup using fallback mechanism");
                return S3RegionUtils.getBucketLocationUsingFallback(bucketName, credentialsProvider, awsConf);
            }
        }
        throw new IllegalArgumentException(String.format("Please set 'ranger.raz.force.s3.region.lookup' property to a valid value, one of 'GOV', 'NON-GOV', or 'FALLBACK'. Current value: %s", forceRegionLookup));
    }

    private static String getBucketLocationUsingFallback(String bucketName, AwsCredentialsProvider credentialsProvider, ApacheHttpClient.Builder awsConf) {
        LOG.debug("Determined Region for S3 client to lookup bucket region: {}", (Object)DETERMINED_REGION_FOR_S3_CLIENT);
        if (DETERMINED_REGION_FOR_S3_CLIENT != null && DETERMINED_REGION_FOR_S3_CLIENT.equals(US_GOV_WEST_1)) {
            try {
                return S3RegionUtils.getBucketLocationFromAWS(bucketName, credentialsProvider, awsConf, US_GOV_WEST_1);
            }
            catch (AwsServiceException ase) {
                LOG.error("Exception caught while getBucketLocation call with us-gov-west-1", (Throwable)ase);
                LOG.info("Fallback Region lookup failed for us-gov-west-1, trying with us-east-1..");
                try {
                    return S3RegionUtils.getBucketLocationFromAWS(bucketName, credentialsProvider, awsConf, US_EAST_1);
                }
                catch (AwsServiceException ase2) {
                    S3RegionUtils.throwAmazonS3ExceptionIfBothFailed(ase, ase2);
                }
            }
        } else {
            try {
                return S3RegionUtils.getBucketLocationFromAWS(bucketName, credentialsProvider, awsConf, US_EAST_1);
            }
            catch (AwsServiceException ase) {
                LOG.error("Exception caught while getBucketLocation call with us-east-1", (Throwable)ase);
                LOG.info("Fallback Region lookup failed for us-east-1, trying with us-gov-west-1..");
                try {
                    return S3RegionUtils.getBucketLocationFromAWS(bucketName, credentialsProvider, awsConf, US_GOV_WEST_1);
                }
                catch (AwsServiceException ase2) {
                    S3RegionUtils.throwAmazonS3ExceptionIfBothFailed(ase, ase2);
                }
            }
        }
        return "";
    }

    private static void throwAmazonS3ExceptionIfBothFailed(AwsServiceException ase, AwsServiceException ase2) {
        LOG.error(String.format("Region lookup failed for both GOV and NON-GOV regions, \n reason for lookup failure for non-gov %s \n reason for lookup failure for gov %s", ase.getMessage(), ase2.getMessage()));
        if (((Object)((Object)ase)).getClass().equals(S3Exception.class)) {
            throw ase;
        }
        throw ase2;
    }

    @VisibleForTesting
    static boolean getIsGovFromInstanceProfile(String instanceProfileArn) {
        if (StringUtils.isBlank((CharSequence)instanceProfileArn)) {
            return false;
        }
        String[] splitInstanceProfile = instanceProfileArn.split(":");
        if (splitInstanceProfile.length > 1) {
            return splitInstanceProfile[1].contains("gov");
        }
        LOG.warn("Couldn't parse instance profile :{} to figure the cloud type", (Object)instanceProfileArn);
        return false;
    }

    @VisibleForTesting
    static String getBucketLocationFromAWS(String bucketName, AwsCredentialsProvider credentialsProvider, ApacheHttpClient.Builder awsConf, String defaultRegion) {
        S3Client s3 = S3RegionUtils.getS3Client(credentialsProvider, awsConf, defaultRegion);
        GetBucketLocationResponse bucketLocation = s3.getBucketLocation((GetBucketLocationRequest)GetBucketLocationRequest.builder().bucket(bucketName).build());
        String regionName = bucketLocation.locationConstraintAsString();
        if (regionName == null || regionName.equals("US") || regionName.isEmpty()) {
            regionName = US_EAST_1;
        }
        S3Utils.updateBucketToRegionCache(bucketName, regionName);
        LOG.info("Region for bucket {}={}", (Object)bucketName, (Object)regionName);
        return regionName;
    }

    @VisibleForTesting
    static S3Client getS3Client(AwsCredentialsProvider credentialsProvider, ApacheHttpClient.Builder httpBuilder, String defaultRegion) {
        S3ClientBuilder s3ClientBuilder = (S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(credentialsProvider)).crossRegionAccessEnabled(Boolean.valueOf(true))).httpClientBuilder((SdkHttpClient.Builder)httpBuilder);
        if (defaultRegion.equals(GS_REGION)) {
            s3ClientBuilder.region(Region.of((String)US_EAST_1));
            URI uri = null;
            try {
                uri = new URI(GS_STORAGE_ENDPOINT);
            }
            catch (URISyntaxException e) {
                String errMsg = String.format("Can't create URI from GS endpoint %s", GS_STORAGE_ENDPOINT);
                LOG.error(errMsg, (Throwable)e);
                throw new RuntimeException(errMsg, e);
            }
            s3ClientBuilder.endpointOverride(uri);
        } else {
            s3ClientBuilder.region(Region.of((String)defaultRegion));
        }
        return (S3Client)s3ClientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String determinedRegion = null;
        try {
            EC2MetadataUtils.IAMInfo iamInfo = EC2MetadataUtils.getIAMInstanceProfileInfo();
            if (iamInfo == null) {
                throw SdkClientException.create((String)"No EC2MetadataUtils info could be found");
            }
            String instanceProfileArn = iamInfo.instanceProfileArn;
            boolean isGov = S3RegionUtils.getIsGovFromInstanceProfile(instanceProfileArn);
            determinedRegion = isGov ? US_GOV_WEST_1 : US_EAST_1;
        }
        catch (Exception e) {
            LOG.error("Exception caught while trying to identify cloud type using EC2MetadataUtils : {}", (Object)e.getMessage());
            LOG.debug("Underlying cause: ", (Throwable)e);
        }
        finally {
            DETERMINED_REGION_FOR_S3_CLIENT = determinedRegion;
        }
    }
}

