/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.signer.util;

import com.cloudera.cloud.storage.relocated.protobuf.ByteString;
import com.cloudera.cloud.storage.relocated.protobuf.CodedOutputStream;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.ranger.raz.s3.lib.HttpMethod;
import org.apache.ranger.raz.s3.lib.signer.SignRequest;
import org.apache.ranger.raz.s3.lib.signer.SignResponse;
import org.apache.ranger.raz.s3.lib.signer.impl.SignRequestImpl;
import org.apache.ranger.raz.s3.lib.signer.impl.SignResponseImpl;
import org.apache.ranger.raz.s3.lib.signer.protos.SignerProtocolProtos;

public class ProtoConverters {
    private static final String CONST_NULL = "_NULL_";

    public static HttpMethod fromProto(SignerProtocolProtos.HttpMethodProto proto) {
        return HttpMethod.valueOf(proto.name());
    }

    public static SignerProtocolProtos.HttpMethodProto toProto(HttpMethod arg) {
        return SignerProtocolProtos.HttpMethodProto.valueOf(arg.name());
    }

    public static SignResponse.AuthorizationResponse.ResponseCode fromProto(SignerProtocolProtos.ResponseCodeProto proto) {
        return SignResponse.AuthorizationResponse.ResponseCode.valueOf(proto.name());
    }

    public static SignerProtocolProtos.ResponseCodeProto toProto(SignResponse.AuthorizationResponse.ResponseCode arg) {
        return SignerProtocolProtos.ResponseCodeProto.valueOf(arg.name());
    }

    public static SignResponse.AuthorizationResponse fromProto(SignerProtocolProtos.AuthorizationResponseProto proto) {
        SignResponse.AuthorizationResponse authorizationResponse = new SignResponse.AuthorizationResponse(ProtoConverters.fromProto(proto.getResponseCode()), proto.getUnauthorizedPathsCount() == 0 ? null : proto.getUnauthorizedPathsList().toArray(new String[proto.getUnauthorizedPathsCount()]), proto.hasResponseMessage() ? proto.getResponseMessage() : null);
        return authorizationResponse;
    }

    public static SignerProtocolProtos.AuthorizationResponseProto toProto(SignResponse.AuthorizationResponse arg) {
        SignerProtocolProtos.AuthorizationResponseProto.Builder builder = SignerProtocolProtos.AuthorizationResponseProto.newBuilder();
        builder.setResponseCode(ProtoConverters.toProto(arg.getResponseCode()));
        if (ArrayUtils.isNotEmpty((Object[])arg.getUnauthorizedPaths())) {
            builder.addAllUnauthorizedPaths(Arrays.asList(arg.getUnauthorizedPaths()));
        }
        if (arg.getResponseMessage() != null) {
            builder.setResponseMessage(arg.getResponseMessage());
        }
        return builder.build();
    }

    public static Map<String, String> fromProto(List<SignerProtocolProtos.StringStringMapProto> list) {
        if (list == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        list.forEach(l -> map.put(l.getKey(), l.getValue()));
        return map;
    }

    public static List<SignerProtocolProtos.StringStringMapProto> toProto(Map<String, String> arg) {
        Preconditions.checkState((!arg.isEmpty() ? 1 : 0) != 0);
        LinkedList<SignerProtocolProtos.StringStringMapProto> list = new LinkedList<SignerProtocolProtos.StringStringMapProto>();
        arg.forEach((k, v) -> list.add(SignerProtocolProtos.StringStringMapProto.newBuilder().setKey((String)k).setValue((String)v).build()));
        return list;
    }

    public static Map<String, List<String>> fromProtoParams(List<SignerProtocolProtos.StringListStringMapProto> list) {
        if (list == null) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(list.size());
        for (SignerProtocolProtos.StringListStringMapProto p : list) {
            if (p.getValueCount() == 0) {
                map.put(p.getKey(), null);
                continue;
            }
            if (p.getValueList().contains(CONST_NULL)) {
                LinkedList<String> newList = new LinkedList<String>();
                for (String s : p.getValueList()) {
                    if (s.equals(CONST_NULL)) {
                        newList.add(null);
                        continue;
                    }
                    newList.add(s);
                }
                map.put(p.getKey(), newList);
                continue;
            }
            map.put(p.getKey(), p.getValueList());
        }
        return map;
    }

    public static List<SignerProtocolProtos.StringListStringMapProto> toProtoParams(Map<String, List<String>> arg) {
        Preconditions.checkState((!arg.isEmpty() ? 1 : 0) != 0);
        LinkedList<SignerProtocolProtos.StringListStringMapProto> list = new LinkedList<SignerProtocolProtos.StringListStringMapProto>();
        for (Map.Entry<String, List<String>> e : arg.entrySet()) {
            SignerProtocolProtos.StringListStringMapProto.Builder builder = SignerProtocolProtos.StringListStringMapProto.newBuilder();
            builder.setKey(e.getKey());
            if (e.getValue() != null) {
                if (e.getValue().contains(null)) {
                    for (String s : e.getValue()) {
                        if (s == null) {
                            builder.addValue(CONST_NULL);
                            continue;
                        }
                        builder.addValue(s);
                    }
                } else {
                    builder.addAllValue((Iterable<String>)e.getValue());
                }
            }
            list.add(builder.build());
        }
        return list;
    }

    public static byte[] fromProto(ByteString byteString) {
        if (byteString == null || byteString.size() == 0) {
            return null;
        }
        return byteString.toByteArray();
    }

    public static ByteString toProto(byte[] args) {
        if (args == null) {
            return ByteString.EMPTY;
        }
        return ByteString.copyFrom(args);
    }

    public static SignRequest fromProto(SignerProtocolProtos.SignRequestProto proto) {
        URI uri;
        try {
            uri = new URI(proto.getEndpoint());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        SignRequestImpl signRequest = new SignRequestImpl(uri, ProtoConverters.fromProto(proto.getHttpMethod()), proto.getHeadersCount() == 0 ? null : ProtoConverters.fromProto(proto.getHeadersList()), proto.getParametersCount() == 0 ? null : ProtoConverters.fromProtoParams(proto.getParametersList()), proto.getResourcePath(), proto.hasContentToSign() ? ProtoConverters.fromProto(proto.getContentToSign()) : null, proto.getTimeOffset(), proto.getEndpointPrefix(), proto.getServiceName());
        return signRequest;
    }

    public static SignerProtocolProtos.SignRequestProto toProto(SignRequest signRequest) {
        SignerProtocolProtos.SignRequestProto.Builder builder = SignerProtocolProtos.SignRequestProto.newBuilder();
        builder.setEndpoint(signRequest.getEndpoint().toString());
        builder.setHttpMethod(ProtoConverters.toProto(signRequest.getHttpMethod()));
        if (!signRequest.getHeaders().isEmpty()) {
            builder.addAllHeaders(ProtoConverters.toProto(signRequest.getHeaders()));
        }
        if (!signRequest.getParameters().isEmpty()) {
            builder.addAllParameters(ProtoConverters.toProtoParams(signRequest.getParameters()));
        }
        builder.setResourcePath(signRequest.getResourcePath());
        if (signRequest.getContentToSign() != null) {
            builder.setContentToSign(ProtoConverters.toProto(signRequest.getContentToSign()));
        }
        builder.setTimeOffset(signRequest.getTimeOffset());
        if (signRequest.getEndpointPrefix() != null) {
            builder.setEndpointPrefix(signRequest.getEndpointPrefix());
        }
        if (signRequest.getServiceName() != null) {
            builder.setServiceName(signRequest.getServiceName());
        }
        return builder.build();
    }

    public static SignResponse fromProto(SignerProtocolProtos.SignResponseProto proto) {
        SignResponse.AuthorizationResponse authorizationResponse = ProtoConverters.fromProto(proto.getAuthorizationResponse());
        Map<String, String> signedHeaders = proto.getSignerGeneratedHeadersCount() == 0 ? null : ProtoConverters.fromProto(proto.getSignerGeneratedHeadersList());
        return new SignResponseImpl(authorizationResponse, signedHeaders, proto.hasRegion() ? proto.getRegion() : null);
    }

    public static SignerProtocolProtos.SignResponseProto toProto(SignResponse arg) {
        SignerProtocolProtos.SignResponseProto.Builder builder = SignerProtocolProtos.SignResponseProto.newBuilder();
        builder.setAuthorizationResponse(ProtoConverters.toProto(arg.getAuthorizationResponse()));
        if (!arg.getSignerGeneratedHeaders().isEmpty()) {
            builder.addAllSignerGeneratedHeaders(ProtoConverters.toProto(arg.getSignerGeneratedHeaders()));
        }
        if (arg.getRegion() != null) {
            builder.setRegion(arg.getRegion());
        }
        return builder.build();
    }

    public static String toBase64(SignResponse signResponse) throws IOException {
        SignerProtocolProtos.SignResponseProto srp = ProtoConverters.toProto(signResponse);
        ByteArrayOutputStream bArrOs = new ByteArrayOutputStream();
        CodedOutputStream stream = CodedOutputStream.newInstance(bArrOs);
        srp.writeTo(stream);
        stream.flush();
        return Base64.getEncoder().encodeToString(bArrOs.toByteArray());
    }

    public static String toBase64(SignRequest signRequest) throws IOException {
        SignerProtocolProtos.SignRequestProto srp = ProtoConverters.toProto(signRequest);
        ByteArrayOutputStream bArrOs = new ByteArrayOutputStream();
        CodedOutputStream stream = CodedOutputStream.newInstance(bArrOs);
        srp.writeTo(stream);
        stream.flush();
        return Base64.getEncoder().encodeToString(bArrOs.toByteArray());
    }

    public static SignRequest reqFromBase64(String srpString) throws IOException {
        byte[] responseProtoBarr = Base64.getDecoder().decode(srpString);
        SignerProtocolProtos.SignRequestProto srp = SignerProtocolProtos.SignRequestProto.parseFrom(responseProtoBarr);
        return ProtoConverters.fromProto(srp);
    }

    public static SignResponse respFromBase64(String srpString) throws IOException {
        byte[] responseProtoBarr = Base64.getDecoder().decode(srpString);
        SignerProtocolProtos.SignResponseProto srp = SignerProtocolProtos.SignResponseProto.parseFrom(responseProtoBarr);
        return ProtoConverters.fromProto(srp);
    }
}

