/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.signer.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import org.apache.ranger.raz.s3.lib.signer.SignResponse;

public class SignResponseImpl
implements SignResponse {
    private final SignResponse.AuthorizationResponse authorizationResponse;
    private final Map<String, String> signerGeneratedHeaders;
    private final String region;

    public SignResponseImpl(SignResponse.AuthorizationResponse authorizationResponse, Map<String, String> signerGeneratedHeaders, String region) {
        this.validateResponseParameters(authorizationResponse, signerGeneratedHeaders);
        this.authorizationResponse = authorizationResponse;
        this.signerGeneratedHeaders = signerGeneratedHeaders;
        this.region = region;
    }

    @Override
    public SignResponse.AuthorizationResponse getAuthorizationResponse() {
        return this.authorizationResponse;
    }

    @Override
    public Map<String, String> getSignerGeneratedHeaders() {
        return this.signerGeneratedHeaders == null ? Collections.EMPTY_MAP : this.signerGeneratedHeaders;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    public String toString() {
        return "SignResponseImpl{authorizationResponse=" + this.authorizationResponse + ", signerGeneratedHeaders=" + this.signerGeneratedHeaders + ", region='" + this.region + '\'' + '}';
    }

    private void validateResponseParameters(SignResponse.AuthorizationResponse authorizationResponse, Map<String, String> signerGeneratedHeaders) {
        Preconditions.checkNotNull((Object)authorizationResponse, (Object)"AuthorizationStatus cannot be empty");
        switch (authorizationResponse.getResponseCode()) {
            case AUTHZ_AUTHORIZED: {
                Preconditions.checkArgument((signerGeneratedHeaders != null && signerGeneratedHeaders.size() != 0 ? 1 : 0) != 0, (Object)"Signer generated headers must be populated for Authorized requests");
                break;
            }
            default: {
                Preconditions.checkState((signerGeneratedHeaders == null ? 1 : 0) != 0, (Object)("Signer generated headers should not be present for ResponseCode: " + (Object)((Object)authorizationResponse.getResponseCode())));
            }
        }
    }
}

