/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.signer.impl;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ranger.raz.s3.lib.HttpMethod;
import org.apache.ranger.raz.s3.lib.signer.SignRequest;

public class SignRequestImpl
implements SignRequest {
    private final String endpointPrefix;
    private final String serviceName;
    private final URI endpoint;
    private final HttpMethod httpMethod;
    private final Map<String, String> headers;
    private final Map<String, List<String>> params;
    private final String resourcePath;
    private final int timeOffset;
    private final byte[] contentToSign;

    public SignRequestImpl(URI endpoint, HttpMethod httpMethod, Map<String, String> headers, Map<String, List<String>> params, String resourcePath, byte[] contentToSign, int timeOffset, String endpointPrefix, String serviceName) {
        Preconditions.checkArgument((endpoint != null ? 1 : 0) != 0, (Object)"endpoint must be specified");
        Preconditions.checkArgument((httpMethod != null ? 1 : 0) != 0, (Object)"httpMethod must be specified");
        Preconditions.checkArgument((resourcePath != null ? 1 : 0) != 0, (Object)"resourcePath must be specified");
        this.endpoint = endpoint;
        this.httpMethod = httpMethod;
        this.headers = headers;
        this.params = params;
        this.resourcePath = resourcePath;
        this.contentToSign = contentToSign;
        this.endpointPrefix = endpointPrefix;
        this.serviceName = serviceName;
        this.timeOffset = timeOffset;
    }

    @Override
    public String getEndpointPrefix() {
        return this.endpointPrefix;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers == null ? Collections.EMPTY_MAP : this.headers;
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return this.params == null ? Collections.EMPTY_MAP : this.params;
    }

    @Override
    public byte[] getContentToSign() {
        return this.contentToSign;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public int getTimeOffset() {
        return this.timeOffset;
    }

    public String toString() {
        return "SignRequestImpl{endpointPrefix='" + this.endpointPrefix + '\'' + ", serviceName='" + this.serviceName + '\'' + ", endpoint=" + this.endpoint + ", httpMethod=" + (Object)((Object)this.httpMethod) + ", headers=" + this.headers + ", params=" + this.params + ", resourcePath='" + this.resourcePath + '\'' + ", timeOffset=" + this.timeOffset + '\'' + ", contentToSignExists: " + (this.contentToSign != null) + '}';
    }
}

