/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.signer;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;

public interface SignResponse {
    public AuthorizationResponse getAuthorizationResponse();

    public Map<String, String> getSignerGeneratedHeaders();

    public String getRegion();

    public static class AuthorizationResponse {
        private final ResponseCode responseCode;
        private final String[] unauthorizedPaths;
        private final String responseMessage;
        public static AuthorizationResponse AUTHORIZED_INSTANCE = new AuthorizationResponse(ResponseCode.AUTHZ_AUTHORIZED, null, null);

        public static AuthorizationResponse getAuthorizedInstance() {
            return AUTHORIZED_INSTANCE;
        }

        public AuthorizationResponse(ResponseCode responseCode, String[] unauthorizedPaths, String responseMessage) {
            Preconditions.checkNotNull((Object)((Object)responseCode), (Object)"ResponseCode must be set");
            this.responseCode = responseCode;
            this.unauthorizedPaths = unauthorizedPaths;
            this.responseMessage = responseMessage;
        }

        public ResponseCode getResponseCode() {
            return this.responseCode;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }

        public String[] getUnauthorizedPaths() {
            return this.unauthorizedPaths;
        }

        public String toString() {
            return "AuthorizationStatus{responseCode=" + (Object)((Object)this.responseCode) + ", unauthorizedPaths=" + Arrays.toString(this.unauthorizedPaths) + ", responseMessage='" + this.responseMessage + '\'' + '}';
        }

        public static enum ResponseCode {
            AUTHZ_AUTHORIZED,
            AUTHZ_UNAUTHORIZED,
            AUTHZ_UNKNOWN,
            ERROR;

        }
    }
}

