/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.perflogger;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ranger.raz.s3.lib.perflogger.PerfLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfLoggerImpl
implements PerfLogger.PerfLoggerInterface {
    private static final Logger LOG = LoggerFactory.getLogger(PerfLoggerImpl.class);
    private static final Logger PERFLOG = LoggerFactory.getLogger((String)"RCS.PERFLOG");
    private final ConcurrentHashMap<Key, Long> beginTimes = new ConcurrentHashMap();

    private PerfLoggerImpl() {
    }

    public static PerfLogger.PerfLoggerInterface get() {
        return Instance.INSTANCE.perfTracker;
    }

    @Override
    public void opBegin(String context, String opName) {
        Key key = new Key(context, opName);
        long beginTime = System.nanoTime();
        Long old = this.beginTimes.put(key, beginTime);
        if (old != null) {
            LOG.debug("Duplicate beginOp for key={}", (Object)key);
        }
        PERFLOG.info("PERFLOG BEGIN: context=[{}], opName=[{}], beginTime=[{}]", new Object[]{context, opName, beginTime});
    }

    @Override
    public long opEnd(String context, String opName) {
        Key key = new Key(context, opName);
        Long beginTime = this.beginTimes.remove(key);
        if (beginTime == null) {
            LOG.debug("No begin information found for key: {}", (Object)key);
        }
        long endTime = System.nanoTime();
        long duration = (endTime - beginTime) / 1000000L;
        PERFLOG.info("PERFLOG END: context=[{}], opName=[{}], duration=[{}], beginTime=[{}], endTime=[{}]", new Object[]{context, opName, duration, beginTime, endTime});
        return duration;
    }

    private static class Key {
        private String context;
        private String opName;

        public Key(String context, String opName) {
            this.context = context;
            this.opName = opName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.context, key.context) && Objects.equals(this.opName, key.opName);
        }

        public int hashCode() {
            return Objects.hash(this.context, this.opName);
        }

        public String toString() {
            return "Key{context='" + this.context + '\'' + ", opName='" + this.opName + '\'' + '}';
        }
    }

    private static enum Instance {
        INSTANCE(new PerfLoggerImpl());

        private final PerfLogger.PerfLoggerInterface perfTracker;

        private Instance(PerfLogger.PerfLoggerInterface perfTracker) {
            this.perfTracker = perfTracker;
        }
    }
}

