/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.awsv2;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ranger.raz.s3.lib.aws.S3Parameters;
import org.apache.ranger.raz.s3.lib.awsv2.ExcludeHeadersSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4FamilyHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.services.s3.internal.s3express.DefaultS3ExpressHttpSigner;
import software.amazon.awssdk.services.s3.s3express.S3ExpressSessionCredentials;

public class S3ExpressSignerForRaz
implements ExcludeHeadersSigner {
    private static final Logger LOG = LoggerFactory.getLogger((String)S3ExpressSignerForRaz.class.getName());
    private final HttpSigner<S3ExpressSessionCredentials> delegateSigner = DefaultS3ExpressHttpSigner.create();

    private boolean isMultiObjectDeleteRequest(SdkHttpFullRequest sdkHttpFullRequest) {
        return sdkHttpFullRequest.method() == SdkHttpMethod.POST && sdkHttpFullRequest.rawQueryParameters().containsKey(S3Parameters.DELETE);
    }

    public SignedRequest sign(SdkHttpFullRequest sdkHttpRequest, String regionName, S3ExpressSessionCredentials s3ExpressSessionCredentials) {
        LOG.debug("==> Signing with S3ExpressSigner");
        Pair<SdkHttpFullRequest, Map<String, List<String>>> pair = this.removeHeadersFromRequest(sdkHttpRequest);
        sdkHttpRequest = (SdkHttpFullRequest)pair.getLeft();
        Map excludedHeaders = (Map)pair.getRight();
        LOG.debug("Request to Sign without headers:{}", (Object)sdkHttpRequest);
        SignRequest.Builder signRequest = (SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)SignRequest.builder((Identity)s3ExpressSessionCredentials).request((SdkHttpRequest)sdkHttpRequest)).putProperty(AwsV4HttpSigner.REGION_NAME, (Object)regionName)).putProperty(AwsV4FamilyHttpSigner.SERVICE_SIGNING_NAME, (Object)"s3express")).putProperty(AwsV4FamilyHttpSigner.DOUBLE_URL_ENCODE, (Object)false)).putProperty(AwsV4FamilyHttpSigner.NORMALIZE_PATH, (Object)false);
        if (this.isMultiObjectDeleteRequest(sdkHttpRequest)) {
            LOG.debug("Request is MultiObbjectDeleteRequest, Adding payload for signing.");
            signRequest.putProperty(AwsV4FamilyHttpSigner.PAYLOAD_SIGNING_ENABLED, (Object)true);
            signRequest.payload(sdkHttpRequest.contentStreamProvider().isPresent() ? sdkHttpRequest.toBuilder().contentStreamProvider() : null);
        } else {
            signRequest.putProperty(AwsV4FamilyHttpSigner.PAYLOAD_SIGNING_ENABLED, (Object)false);
        }
        SignedRequest signedRequest = this.delegateSigner.sign((SignRequest)signRequest.build());
        SdkHttpFullRequest requestWithAllHeaders = this.putBackHeader((SdkHttpFullRequest)signedRequest.request(), excludedHeaders);
        LOG.debug("Final Signed Request:{}", (Object)requestWithAllHeaders);
        return (SignedRequest)((SignedRequest.Builder)((SignedRequest.Builder)signedRequest.toBuilder()).request((SdkHttpRequest)requestWithAllHeaders)).build();
    }
}

