/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.awsv2;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import software.amazon.awssdk.http.SdkHttpFullRequest;

public interface ExcludeHeadersSigner {
    public static final List<String> listOfHeadersToIgnoreInLowerCase = Arrays.asList("connection", "x-amzn-trace-id", "range", "amz-sdk-invocation-id", "amz-sdk-request", "amz-sdk-retry", "if-match", "referer");
    public static final Map<String, List<String>> requestHeadersToExclude = new HashMap<String, List<String>>();

    default public SdkHttpFullRequest putBackHeader(SdkHttpFullRequest signedRequest, Map<String, List<String>> excludedHeaders) {
        SdkHttpFullRequest.Builder signedRequestBuilder = signedRequest.toBuilder();
        excludedHeaders.forEach((arg_0, arg_1) -> ((SdkHttpFullRequest.Builder)signedRequestBuilder).putHeader(arg_0, arg_1));
        return signedRequestBuilder.build();
    }

    default public Pair<SdkHttpFullRequest, Map<String, List<String>>> removeHeadersFromRequest(SdkHttpFullRequest sdkHttpRequest) {
        HashMap requestHeadersToExclude = new HashMap();
        SdkHttpFullRequest.Builder httpRequestWithRemovedHeaders = sdkHttpRequest.toBuilder();
        sdkHttpRequest.headers().forEach((key, value) -> {
            if (listOfHeadersToIgnoreInLowerCase.contains(key.toLowerCase(Locale.ENGLISH))) {
                requestHeadersToExclude.put(key, value);
                httpRequestWithRemovedHeaders.removeHeader(key);
            }
        });
        return Pair.of((Object)httpRequestWithRemovedHeaders.build(), requestHeadersToExclude);
    }
}

