/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.awsv2;

import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ranger.raz.s3.lib.awsv2.ExcludeHeadersSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.auth.signer.internal.AbstractAwsS3V4Signer;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.SdkHttpFullRequest;

public class AWSS3V4SignerForRaz
extends AbstractAwsS3V4Signer
implements Signer,
ExcludeHeadersSigner {
    private static final Logger LOG = LoggerFactory.getLogger(AWSS3V4SignerForRaz.class);
    private final Signer delegateSigner;

    public AWSS3V4SignerForRaz(Signer delegateSigner) {
        this.delegateSigner = delegateSigner;
    }

    public SdkHttpFullRequest sign(SdkHttpFullRequest sdkHttpFullRequest, ExecutionAttributes executionAttributes) {
        LOG.debug("Excluding some headers before signing the request");
        Pair pair = this.removeHeadersFromRequest(sdkHttpFullRequest);
        SdkHttpFullRequest requestBeforeSigning = (SdkHttpFullRequest)pair.getLeft();
        Map excludedHeaders = (Map)pair.getRight();
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNER_DOUBLE_URL_ENCODE, (Object)Boolean.FALSE);
        SdkHttpFullRequest signedRequest = this.delegateSigner.sign(requestBeforeSigning, executionAttributes);
        signedRequest = this.putBackHeader(signedRequest, excludedHeaders);
        return signedRequest;
    }
}

