/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.aws.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RequestBodyParser {
    public DeleteObjects parseDeleteObjectsRequest(InputStream is) {
        SAXParser parser = this.getParser();
        DeleteObjectsHandler deleteHandler = new DeleteObjectsHandler();
        try {
            parser.parse(is, (DefaultHandler)deleteHandler);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException("Failed to parse Delete request", e);
        }
        return deleteHandler.getDeleteObjects();
    }

    private SAXParser getParser() {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            return saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Failed to create SAXParser", e);
        }
    }

    public static class DeleteObjectEntity {
        private String key;
        private String versionId;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public String toString() {
            return "DeleteObjectEntity{key='" + this.key + '\'' + ", versionId='" + this.versionId + '\'' + '}';
        }
    }

    public static class DeleteObjects {
        private boolean quiet = false;
        private List<DeleteObjectEntity> deleteEntities = new LinkedList<DeleteObjectEntity>();

        public boolean isQuiet() {
            return this.quiet;
        }

        public void setQuiet(boolean quiet) {
            this.quiet = quiet;
        }

        public List<DeleteObjectEntity> getDeleteEntities() {
            return this.deleteEntities;
        }

        public void addDeleteEntity(DeleteObjectEntity deleteEntity) {
            this.deleteEntities.add(deleteEntity);
        }

        public String toString() {
            return "DeleteObjects{quiet=" + this.quiet + ", deleteEntities=" + this.deleteEntities + '}';
        }
    }

    static class DeleteObjectsHandler
    extends DefaultHandler {
        private DeleteObjects deleteObjects = null;
        private DeleteObjectEntity currentDeleteObject = null;
        private boolean q = false;
        private boolean k = false;
        private boolean v = false;

        DeleteObjectsHandler() {
        }

        public DeleteObjects getDeleteObjects() {
            return this.deleteObjects;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("delete")) {
                this.deleteObjects = new DeleteObjects();
            } else if (qName.equalsIgnoreCase("quiet")) {
                this.q = true;
            } else if (qName.equalsIgnoreCase("object")) {
                this.currentDeleteObject = new DeleteObjectEntity();
            } else if (qName.equalsIgnoreCase("key")) {
                this.k = true;
            } else if (qName.equalsIgnoreCase("versionid")) {
                this.v = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.q) {
                this.q = false;
                String quietString = new String(ch, start, length);
                boolean quiet = Boolean.valueOf(quietString.toLowerCase());
                this.deleteObjects.setQuiet(quiet);
            } else if (this.k) {
                this.k = false;
                String deleteKey = new String(ch, start, length);
                this.currentDeleteObject.setKey(deleteKey);
            } else if (this.v) {
                this.v = false;
                String versionIdString = new String(ch, start, length);
                this.currentDeleteObject.setVersionId(versionIdString);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("object")) {
                this.deleteObjects.addDeleteEntity(this.currentDeleteObject);
                this.currentDeleteObject = null;
            }
        }
    }
}

