/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.aws.parsers;

import com.amazonaws.Request;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.ranger.raz.s3.lib.annotations.AudienceElement;
import org.apache.ranger.raz.s3.lib.annotations.InterfaceAudience;
import org.apache.ranger.raz.s3.lib.aws.S3Parameters;
import org.apache.ranger.raz.s3.lib.aws.exceptions.RCSAWSException;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsDeleteObjectRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsDeleteObjectsRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsGetBucketAclRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsGetBucketLocationRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsHeadBucketRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsHeadObjectRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsListPartsRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsListV1Request;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsListV2Request;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsMultiPartAbortRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsMultiPartListUploadsRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsMultipartCommitRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsMultipartInitiateRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsMultipartUploadRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsPutObjectRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsReadObjectRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsSelectObjectContentRequest;
import org.apache.ranger.raz.s3.lib.exceptions.RCSUncheckedException;
import org.apache.ranger.raz.s3.lib.signer.ContentSigningRequired;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience(value=AudienceElement.Private)
public class AwsRequestParser {
    private static final Logger LOG = LoggerFactory.getLogger(AwsRequestParser.class);
    private static final String CREATE_METHOD_NAME = "create";

    public AwsRequest parseAwsRequest(Request<?> request) {
        LOG.debug("Parsing incoming request: {} ", request);
        AwsRequestHolder awsRequestHolder = this.getAwsRequestHolder(request, true);
        return awsRequestHolder.getAwsRequest();
    }

    public boolean isContentSigningRequired(Request<?> request) {
        AwsRequestHolder awsRequestHolder;
        try {
            awsRequestHolder = this.getAwsRequestHolder(request, false);
        }
        catch (RCSUncheckedException e) {
            throw new RCSAWSException(RCSAWSException.StatusCode.BAD_REQUEST, "Unable to interpret request", e);
        }
        ContentSigningRequired annotation = awsRequestHolder.getRequestClazz().getAnnotation(ContentSigningRequired.class);
        if (annotation == null) {
            LOG.warn("Expected" + ContentSigningRequired.class + " annotation not found on " + awsRequestHolder.getRequestClazz());
            throw new IllegalStateException("Expected" + ContentSigningRequired.class + " annotation not found on " + awsRequestHolder.getRequestClazz());
        }
        return annotation.value();
    }

    private AwsRequestHolder getAwsRequestHolder(Request<?> request, boolean instantiate) throws RCSUncheckedException {
        Map parameters = request.getParameters();
        String resourcePath = request.getResourcePath();
        switch (request.getHttpMethod()) {
            case GET: {
                if (resourcePath.equals("")) {
                    if (parameters.containsKey(S3Parameters.LOCATION)) {
                        return new AwsRequestHolder(AwsGetBucketLocationRequest.class, request, instantiate);
                    }
                    if (parameters.containsKey(S3Parameters.LIST_TYPE)) {
                        return new AwsRequestHolder(AwsListV2Request.class, request, instantiate);
                    }
                    if (parameters.containsKey(S3Parameters.UPLOADS)) {
                        return new AwsRequestHolder(AwsMultiPartListUploadsRequest.class, request, instantiate);
                    }
                    if (parameters.containsKey(S3Parameters.ACL)) {
                        return new AwsRequestHolder(AwsGetBucketAclRequest.class, request, instantiate);
                    }
                    return new AwsRequestHolder(AwsListV1Request.class, request, instantiate);
                }
                if (parameters == null || parameters.isEmpty()) {
                    return new AwsRequestHolder(AwsReadObjectRequest.class, request, instantiate);
                }
                if (parameters.containsKey(S3Parameters.UPLOAD_ID)) {
                    return new AwsRequestHolder(AwsListPartsRequest.class, request, instantiate);
                }
                this.handleUnknownRequestType(request);
                break;
            }
            case POST: {
                if (parameters.containsKey(S3Parameters.DELETE)) {
                    return new AwsRequestHolder(AwsDeleteObjectsRequest.class, request, instantiate);
                }
                if (parameters.containsKey(S3Parameters.UPLOADS)) {
                    return new AwsRequestHolder(AwsMultipartInitiateRequest.class, request, instantiate);
                }
                if (parameters.containsKey(S3Parameters.UPLOAD_ID)) {
                    return new AwsRequestHolder(AwsMultipartCommitRequest.class, request, instantiate);
                }
                if (parameters.containsKey(S3Parameters.SELECT) && parameters.containsKey(S3Parameters.SELECT_TYPE)) {
                    return new AwsRequestHolder(AwsSelectObjectContentRequest.class, request, instantiate);
                }
                this.handleUnknownRequestType(request);
                break;
            }
            case PUT: {
                if (parameters.containsKey(S3Parameters.UPLOAD_ID)) {
                    return new AwsRequestHolder(AwsMultipartUploadRequest.class, request, instantiate);
                }
                if (parameters == null || parameters.isEmpty()) {
                    return new AwsRequestHolder(AwsPutObjectRequest.class, request, instantiate);
                }
                this.handleUnknownRequestType(request);
                break;
            }
            case HEAD: {
                if (resourcePath.equals("")) {
                    return new AwsRequestHolder(AwsHeadBucketRequest.class, request, instantiate);
                }
                return new AwsRequestHolder(AwsHeadObjectRequest.class, request, instantiate);
            }
            case DELETE: {
                if (parameters.containsKey(S3Parameters.UPLOAD_ID)) {
                    return new AwsRequestHolder(AwsMultiPartAbortRequest.class, request, instantiate);
                }
                return new AwsRequestHolder(AwsDeleteObjectRequest.class, request, instantiate);
            }
            default: {
                this.handleUnknownRequestType(request);
            }
        }
        return null;
    }

    public byte[] getRequestContents(Request<?> request) throws IOException {
        InputStream inputStream = request.getContent();
        if (inputStream == null) {
            return null;
        }
        if (!inputStream.markSupported()) {
            AwsRequestHolder requestHolder = null;
            try {
                requestHolder = this.getAwsRequestHolder(request, false);
            }
            catch (RCSUncheckedException e) {
                LOG.warn("Failed to extract AWS operation", (Throwable)e);
            }
            throw new IllegalStateException("AWS SDK is supposed to be using streams which support mark. RequestType: " + (requestHolder == null ? "Unknown, see previous trace in log" : requestHolder.getRequestClazz()));
        }
        inputStream.mark(Integer.MAX_VALUE);
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        inputStream.reset();
        return bytes;
    }

    private void handleUnknownRequestType(Request<?> request) {
        throw new RCSUncheckedException(RCSUncheckedException.Code.UNRECOGNIZED_REQUEST_TYPE, String.format("Unknown request type. Method=[%s], Headers=[%s], Parameters=[%s], ResourcePath=[%s]", request.getHttpMethod(), request.getHeaders(), request.getParameters(), request.getResourcePath()));
    }

    private static class AwsRequestHolder {
        Class<? extends AwsRequest> requestClazz;
        AwsRequest awsRequest;

        public AwsRequestHolder(Class<? extends AwsRequest> requestClazz, Request<?> request, boolean instantiate) {
            this.requestClazz = requestClazz;
            if (instantiate) {
                try {
                    LOG.debug("AwsRequestHolder instantiate class: {}", (Object)requestClazz.getName());
                    Method method = requestClazz.getMethod(AwsRequestParser.CREATE_METHOD_NAME, Request.class);
                    this.awsRequest = (AwsRequest)method.invoke(null, request);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RCSUncheckedException(RCSUncheckedException.Code.GENERAL_SERVER_ERROR, "Unable to instantiate: [" + requestClazz + "]", e);
                }
            }
        }

        public Class<? extends AwsRequest> getRequestClazz() {
            return this.requestClazz;
        }

        public AwsRequest getAwsRequest() {
            return this.awsRequest;
        }
    }
}

