/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.aws.fsrequests;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ranger.raz.s3.lib.RazS3Constants;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsOperationType;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsRequest;

public class AwsRequestCacheKey {
    private final AwsOperationType operationType;
    private final URI endpoint;
    private final Map<String, List<String>> parameters;
    private final String bucket;
    private final Map<RazS3Constants.AccessType, List<String>> resourcePaths;
    private final RazS3Constants.AccessType accessType;
    private final String requestOwner;

    public AwsRequestCacheKey(AwsRequest awsRequest, String requestOwner) {
        this.operationType = awsRequest.getOperationType();
        this.endpoint = awsRequest.getEndpoint();
        this.parameters = awsRequest.getParameters();
        this.bucket = awsRequest.getBucket();
        this.resourcePaths = awsRequest.getPathsToAuthorize();
        this.accessType = awsRequest.getRequiredAuthorization();
        this.requestOwner = requestOwner;
    }

    @VisibleForTesting
    public AwsRequestCacheKey(AwsOperationType operationType, URI endpoint, Map<String, List<String>> parameters, String bucket, Map<RazS3Constants.AccessType, List<String>> resourcePaths, RazS3Constants.AccessType accessType, String requestOwner) {
        this.operationType = operationType;
        this.endpoint = endpoint;
        this.parameters = parameters;
        this.bucket = bucket;
        this.resourcePaths = resourcePaths;
        this.accessType = accessType;
        this.requestOwner = requestOwner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsRequestCacheKey that = (AwsRequestCacheKey)o;
        return this.operationType == that.operationType && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.resourcePaths, that.resourcePaths) && this.accessType == that.accessType && this.requestOwner.equals(that.requestOwner);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.operationType, this.endpoint, this.parameters, this.bucket, this.accessType, this.requestOwner});
        result = 31 * result + this.resourcePaths.hashCode();
        return result;
    }

    public String toString() {
        return "AwsRequestCacheKey{operationType=" + (Object)((Object)this.operationType) + ", endpoint=" + this.endpoint + ", parameters=" + this.parameters + ", bucket='" + this.bucket + '\'' + ", resourcePaths=" + this.resourcePaths.toString() + ", accessType=" + (Object)((Object)this.accessType) + ", requestOwner='" + this.requestOwner + '\'' + '}';
    }
}

