/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.aws.fsrequests;

import com.amazonaws.http.HttpMethodName;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ranger.raz.s3.lib.RazS3Constants;
import org.apache.ranger.raz.s3.lib.authorizer.AuthorizationRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsOperationType;
import org.apache.ranger.raz.s3.lib.signer.ContentSigningRequired;
import org.apache.ranger.raz.s3.lib.utils.S3Utils;

@ContentSigningRequired(value=false)
public abstract class AwsRequest
implements AuthorizationRequest {
    private final AwsOperationType operationType;
    private final URI endpoint;
    private final Map<String, String> headers;
    private final Map<String, List<String>> parameters;
    private final String bucket;
    private Map<RazS3Constants.AccessType, List<String>> resourcePaths;
    private RazS3Constants.AccessType accessType;

    protected AwsRequest(AwsOperationType operationType, URI endpoint, Map<String, String> headers, Map<String, List<String>> parameters, String resourcePath, RazS3Constants.AccessType accessType) {
        this(operationType, endpoint, headers, parameters, new String[]{resourcePath}, accessType);
    }

    protected AwsRequest(AwsOperationType operationType, URI endpoint, Map<String, String> headers, Map<String, List<String>> parameters, Map<RazS3Constants.AccessType, List<String>> resourcePaths, RazS3Constants.AccessType accessType) {
        this(operationType, endpoint, headers, parameters);
        Objects.requireNonNull(resourcePaths);
        HashMap<RazS3Constants.AccessType, List<String>> pathMap = new HashMap<RazS3Constants.AccessType, List<String>>();
        resourcePaths.forEach((key, paths) -> {
            ArrayList<String> updatedPaths = new ArrayList<String>();
            for (String path : paths) {
                updatedPaths.add(this.standardizePath(path));
            }
            pathMap.put((RazS3Constants.AccessType)((Object)key), (List<String>)updatedPaths);
        });
        this.resourcePaths = pathMap;
        this.accessType = accessType;
    }

    private String standardizePath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    protected AwsRequest(AwsOperationType operationType, URI endpoint, Map<String, String> headers, Map<String, List<String>> parameters, String[] resourcePaths, RazS3Constants.AccessType accessType) {
        this(operationType, endpoint, headers, parameters);
        Objects.requireNonNull(resourcePaths);
        String[] paths = new String[resourcePaths.length];
        int count = 0;
        for (String path : resourcePaths) {
            paths[count++] = this.standardizePath(path);
        }
        HashMap<RazS3Constants.AccessType, List<String>> pathMap = new HashMap<RazS3Constants.AccessType, List<String>>();
        pathMap.put(accessType, Arrays.asList(paths));
        this.resourcePaths = pathMap;
        this.accessType = accessType;
    }

    protected AwsRequest(AwsOperationType operationType, URI endpoint, Map<String, String> headers, Map<String, List<String>> parameters) {
        Objects.requireNonNull(endpoint);
        Objects.requireNonNull(operationType);
        Objects.requireNonNull(headers);
        Objects.requireNonNull(parameters);
        this.operationType = operationType;
        this.endpoint = endpoint;
        String bucketName = S3Utils.getBucketNameFromHost(endpoint.getHost());
        Preconditions.checkState((bucketName != null ? 1 : 0) != 0, (Object)("Could not extract bucket name from endpoint: [" + endpoint.toString() + "]"));
        this.bucket = bucketName;
        this.headers = headers;
        this.parameters = parameters;
    }

    public AwsOperationType getOperationType() {
        return this.operationType;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public HttpMethodName getHttpMethodName() {
        return this.operationType.getHttpMethodName();
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    @Override
    public Map<RazS3Constants.AccessType, List<String>> getPathsToAuthorize() {
        return this.resourcePaths;
    }

    @Override
    public RazS3Constants.AccessType getRequiredAuthorization() {
        return this.accessType;
    }

    public boolean isSignatureCachingAllowed() {
        return this.getOperationType().equals((Object)AwsOperationType.READ_OBJECT);
    }

    public String toString() {
        return "AwsRequest{operationType=" + (Object)((Object)this.operationType) + ", endpoint=" + this.endpoint + ", headers=" + this.headers + ", parameters=" + this.parameters + ", bucket=" + this.bucket + ", resourcePaths=" + this.resourcePaths.toString() + '}';
    }
}

