/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.aws.fsrequests;

import com.amazonaws.Request;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ranger.raz.s3.lib.RazS3Constants;
import org.apache.ranger.raz.s3.lib.authorizer.CloudHttpRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsOperationType;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsRequest;
import org.apache.ranger.raz.s3.lib.utils.S3Utils;

public class AwsPutObjectRequest
extends AwsRequest {
    private static final String X_AMZ_COPY_SOURCE = "x-amz-copy-source";

    private AwsPutObjectRequest(URI endpoint, Map<String, String> headers, Map<String, List<String>> parameters, Map<RazS3Constants.AccessType, List<String>> resourcePaths) {
        super(AwsOperationType.PUT_OBJECT, endpoint, headers, parameters, resourcePaths, RazS3Constants.AccessType.WRITE);
    }

    public static AwsPutObjectRequest create(Request<?> request) {
        HashMap<RazS3Constants.AccessType, List<String>> resourcePaths = new HashMap<RazS3Constants.AccessType, List<String>>();
        resourcePaths.put(RazS3Constants.AccessType.WRITE, Collections.singletonList(request.getResourcePath()));
        ArrayList<String> readPaths = new ArrayList<String>();
        String copySource = (String)request.getHeaders().get(X_AMZ_COPY_SOURCE);
        if (copySource != null) {
            String bucketName = S3Utils.getBucketNameFromHost(request.getEndpoint().getHost());
            Preconditions.checkState((bucketName != null ? 1 : 0) != 0, (Object)("Could not extract bucket name from host: [" + request.getEndpoint().getHost() + "]"));
            readPaths.add(S3Utils.truncateBucketNameFromPath(copySource, bucketName));
            resourcePaths.put(RazS3Constants.AccessType.READ, readPaths);
        }
        return new AwsPutObjectRequest(request.getEndpoint(), request.getHeaders(), request.getParameters(), resourcePaths);
    }

    public static AwsPutObjectRequest createV2(CloudHttpRequest request) throws URISyntaxException {
        HashMap<RazS3Constants.AccessType, List<String>> resourcePaths = new HashMap<RazS3Constants.AccessType, List<String>>();
        resourcePaths.put(RazS3Constants.AccessType.WRITE, Collections.singletonList(request.getResourcePath()));
        ArrayList<String> readPaths = new ArrayList<String>();
        String copySource = request.getHeaders().get(X_AMZ_COPY_SOURCE);
        if (copySource != null) {
            String bucketName = S3Utils.getBucketNameFromHost(request.getEndpoint().getHost());
            Preconditions.checkState((bucketName != null ? 1 : 0) != 0, (Object)("Could not extract bucket name from host: [" + request.getEndpoint().getHost() + "]"));
            readPaths.add(S3Utils.truncateBucketNameFromPath(copySource, bucketName));
            resourcePaths.put(RazS3Constants.AccessType.READ, readPaths);
        }
        return new AwsPutObjectRequest(request.getEndpoint(), request.getHeaders(), request.getParameters(), resourcePaths);
    }
}

