/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.aws.fsrequests;

import com.amazonaws.Request;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.ranger.raz.s3.lib.RazS3Constants;
import org.apache.ranger.raz.s3.lib.authorizer.CloudHttpRequest;
import org.apache.ranger.raz.s3.lib.aws.S3Parameters;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsOperationType;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsRequest;

public class AwsMultiPartListUploadsRequest
extends AwsRequest {
    private AwsMultiPartListUploadsRequest(URI endpoint, Map<String, String> headers, Map<String, List<String>> parameters, String resourcePath) {
        super(AwsOperationType.MULTIPART_LIST, endpoint, headers, parameters, resourcePath, RazS3Constants.AccessType.READ);
    }

    public static AwsMultiPartListUploadsRequest create(Request<?> request) {
        List prefixParams = (List)request.getParameters().get(S3Parameters.PREFIX);
        Preconditions.checkState((prefixParams != null && prefixParams.size() == 1 ? 1 : 0) != 0, (Object)(S3Parameters.PREFIX + " should have exactly one value"));
        return new AwsMultiPartListUploadsRequest(request.getEndpoint(), request.getHeaders(), request.getParameters(), (String)prefixParams.get(0));
    }

    public static AwsMultiPartListUploadsRequest createV2(CloudHttpRequest request) throws URISyntaxException {
        List<String> prefixParams = request.getParameters().get(S3Parameters.PREFIX);
        return new AwsMultiPartListUploadsRequest(request.getEndpoint(), request.getHeaders(), request.getParameters(), prefixParams != null && prefixParams.size() >= 1 ? prefixParams.get(0) : "");
    }
}

