/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.aws.fsrequests;

import com.amazonaws.Request;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.ranger.raz.s3.lib.RazS3Constants;
import org.apache.ranger.raz.s3.lib.authorizer.CloudHttpRequest;
import org.apache.ranger.raz.s3.lib.aws.S3Parameters;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsOperationType;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsListV1Request
extends AwsRequest {
    private static final Logger LOG = LoggerFactory.getLogger((String)AwsListV1Request.class.getName());

    private AwsListV1Request(URI endpoint, Map<String, String> headers, Map<String, List<String>> parameters, String resourcePath) {
        super(AwsOperationType.LIST_V1, endpoint, headers, parameters, resourcePath, RazS3Constants.AccessType.READ);
    }

    public static AwsListV1Request create(Request<?> request) {
        String resourcePath = AwsListV1Request.getResourcePath(request.getParameters());
        return new AwsListV1Request(request.getEndpoint(), request.getHeaders(), request.getParameters(), resourcePath);
    }

    public static AwsListV1Request createV2(CloudHttpRequest request) throws URISyntaxException {
        String resourcePath = AwsListV1Request.getResourcePath(request.getParameters());
        return new AwsListV1Request(request.getEndpoint(), request.getHeaders(), request.getParameters(), resourcePath);
    }

    private static String getResourcePath(Map<String, List<String>> parameters) {
        List<String> prefixParams = parameters.get(S3Parameters.PREFIX);
        if (prefixParams == null || prefixParams.size() == 0) {
            LOG.debug("Prefix Params is null or empty. Assuming bucket root list: {}", prefixParams);
        }
        Preconditions.checkState((prefixParams == null || prefixParams.size() == 0 || prefixParams.size() == 1 ? 1 : 0) != 0, (Object)(S3Parameters.PREFIX + " should be null, or containt 0/1 argument"));
        return prefixParams == null || prefixParams.size() == 0 ? "" : prefixParams.get(0);
    }
}

