/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.aws.fsrequests;

import com.amazonaws.Request;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.ranger.raz.s3.lib.RazS3Constants;
import org.apache.ranger.raz.s3.lib.authorizer.CloudHttpRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsOperationType;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsRequest;

public class AwsListPartsRequest
extends AwsRequest {
    private AwsListPartsRequest(URI endpoint, Map<String, String> headers, Map<String, List<String>> parameters, String resourcePath) {
        super(AwsOperationType.MULTIPART_LIST_PARTS, endpoint, headers, parameters, resourcePath, RazS3Constants.AccessType.READ);
    }

    public static AwsListPartsRequest create(Request<?> request) {
        String key = request.getResourcePath();
        Preconditions.checkState((key != null && key.length() >= 1 ? 1 : 0) != 0, (Object)"key should be of minimum length 1");
        return new AwsListPartsRequest(request.getEndpoint(), request.getHeaders(), request.getParameters(), key);
    }

    public static AwsListPartsRequest createV2(CloudHttpRequest request) throws URISyntaxException {
        String key = request.getResourcePath();
        Preconditions.checkState((key != null && key.length() >= 1 ? 1 : 0) != 0, (Object)"key should be of minimum length 1");
        return new AwsListPartsRequest(request.getEndpoint(), request.getHeaders(), request.getParameters(), key);
    }
}

