/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.aws.fsrequests;

import com.amazonaws.Request;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.ranger.raz.s3.lib.RazS3Constants;
import org.apache.ranger.raz.s3.lib.authorizer.CloudHttpRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsOperationType;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsRequest;
import org.apache.ranger.raz.s3.lib.aws.parsers.RequestBodyParser;
import org.apache.ranger.raz.s3.lib.signer.ContentSigningRequired;

@ContentSigningRequired(value=true)
public class AwsDeleteObjectsRequest
extends AwsRequest {
    private AwsDeleteObjectsRequest(URI endpoint, Map<String, String> headers, Map<String, List<String>> parameters, String[] resourcePaths) {
        super(AwsOperationType.DELETE_OBJECTS, endpoint, headers, parameters, resourcePaths, RazS3Constants.AccessType.WRITE);
    }

    public static AwsDeleteObjectsRequest create(Request<?> request) throws IOException {
        String[] paths = AwsDeleteObjectsRequest.getPathsToAuth(request.getContent());
        return new AwsDeleteObjectsRequest(request.getEndpoint(), request.getHeaders(), request.getParameters(), paths);
    }

    public static AwsDeleteObjectsRequest createV2(CloudHttpRequest request) throws IOException, URISyntaxException {
        String[] paths = AwsDeleteObjectsRequest.getPathsToAuth(request.getContent());
        return new AwsDeleteObjectsRequest(request.getEndpoint(), request.getHeaders(), request.getParameters(), paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getPathsToAuth(InputStream is) throws IOException {
        if (is == null) {
            is = new ByteArrayInputStream("<Delete></Delete>".getBytes());
        }
        Preconditions.checkState((boolean)is.markSupported(), (Object)"mark not supported on delete request stream. Parsing the contents here will cause subsequent failure when the contents are consumed");
        is.mark(Integer.MAX_VALUE);
        RequestBodyParser requestBodyParser = new RequestBodyParser();
        try {
            String[] paths;
            RequestBodyParser.DeleteObjects deleteObjects = requestBodyParser.parseDeleteObjectsRequest(is);
            String[] stringArray = paths = (String[])deleteObjects.getDeleteEntities().stream().map(RequestBodyParser.DeleteObjectEntity::getKey).toArray(String[]::new);
            return stringArray;
        }
        finally {
            is.reset();
        }
    }
}

