/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.s3.lib.authorizer.impl;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ranger.raz.s3.lib.authorizer.CloudHttpRequest;
import software.amazon.awssdk.http.SdkHttpFullRequest;

public class S3CloudHttpRequest
implements CloudHttpRequest {
    private final SdkHttpFullRequest.Builder requestBuilder;

    public S3CloudHttpRequest(SdkHttpFullRequest request) {
        this.requestBuilder = request.toBuilder();
    }

    @Override
    public URI getEndpoint() throws URISyntaxException {
        return new URI(this.requestBuilder.protocol() + "://" + this.requestBuilder.host());
    }

    @Override
    public Map<String, String> getHeaders() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        this.requestBuilder.headers().forEach((key, value) -> {
            String val = String.join((CharSequence)",", value);
            headerMap.put((String)key, val);
        });
        return headerMap;
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return this.requestBuilder.rawQueryParameters();
    }

    @Override
    public String getResourcePath() {
        return this.requestBuilder.encodedPath();
    }

    @Override
    public String method() {
        return this.requestBuilder.method().name();
    }

    @Override
    public InputStream getContent() {
        return this.requestBuilder.contentStreamProvider().newStream();
    }
}

