/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerRazRequestBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String requestId;
    private String serviceType;
    private String serviceName;
    private String user;
    private Set<String> userGroups;
    private Date accessTime;
    private String clientIpAddress;
    private String clientType;
    private String clusterName;
    private String clusterType;
    private String sessionId;
    private Set<String> keysToRedact;
    private Map<String, String> context;

    public RangerRazRequestBase() {
    }

    public RangerRazRequestBase(RangerRazRequestBase other) {
        this.requestId = other.requestId;
        this.serviceType = other.serviceType;
        this.serviceName = other.serviceName;
        this.user = other.user;
        this.userGroups = other.userGroups;
        this.accessTime = other.accessTime;
        this.clientIpAddress = other.clientIpAddress;
        this.clientType = other.clientType;
        this.clusterName = other.clusterName;
        this.clusterType = other.clusterType;
        this.sessionId = other.sessionId;
        this.context = other.context;
        this.keysToRedact = other.keysToRedact;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Set<String> getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(Set<String> userGroups) {
        this.userGroups = userGroups;
    }

    public Date getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(Date accessTime) {
        this.accessTime = accessTime;
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public void setClientIpAddress(String clientIpAddress) {
        this.clientIpAddress = clientIpAddress;
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(String clusterType) {
        this.clusterType = clusterType;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public Set<String> getKeysToRedact() {
        return this.keysToRedact;
    }

    public void setKeysToRedact(Set<String> keysToRedact) {
        this.keysToRedact = keysToRedact;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerRazRequest={");
        sb.append("requestId={").append(this.requestId).append("} ");
        sb.append("serviceType={").append(this.serviceType).append("} ");
        sb.append("serviceName={").append(this.serviceName).append("} ");
        sb.append("user={").append(this.user).append("} ");
        sb.append("userGroups=[");
        if (this.userGroups != null) {
            for (String userGroup : this.userGroups) {
                sb.append(userGroup).append(" ");
            }
        }
        sb.append("] ");
        sb.append("accessTime={").append(this.accessTime).append("} ");
        sb.append("clientIpAddress={").append(this.clientIpAddress).append("} ");
        sb.append("clientType={").append(this.clientType).append("} ");
        sb.append("clusterName={").append(this.clusterName).append("} ");
        sb.append("clusterType={").append(this.clusterType).append("} ");
        sb.append("sessionId={").append(this.sessionId).append("} ");
        sb.append("context={");
        if (this.context != null) {
            Set<String> redactKeys = this.getKeysToRedact();
            for (Map.Entry<String, String> e : this.context.entrySet()) {
                String key = e.getKey();
                sb.append(key).append("={");
                sb.append(CollectionUtils.isNotEmpty(redactKeys) && redactKeys.contains(key) ? "********" : e.getValue());
                sb.append("} ");
            }
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResourceAccess
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, String> resource;
        private String resourceOwner;
        private String action;
        private Set<String> accessTypes;

        public ResourceAccess() {
        }

        public ResourceAccess(Map<String, String> resource, String action) {
            this.resource = resource;
            this.action = action;
        }

        public ResourceAccess(Map<String, String> resource, String resourceOwner, String action, Set<String> accessTypes) {
            this.resource = resource;
            this.resourceOwner = resourceOwner;
            this.action = action;
            this.accessTypes = accessTypes;
        }

        public Map<String, String> getResource() {
            return this.resource;
        }

        public void setResource(Map<String, String> resource) {
            this.resource = resource;
        }

        public String getResourceOwner() {
            return this.resourceOwner;
        }

        public void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public Set<String> getAccessTypes() {
            return this.accessTypes;
        }

        public void setAccessTypes(Set<String> accessTypes) {
            this.accessTypes = accessTypes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("ResourceAccess={");
            sb.append("resource={");
            if (this.resource != null) {
                for (Map.Entry<String, String> e : this.resource.entrySet()) {
                    sb.append(e.getKey()).append("=");
                    sb.append(e.getValue());
                    sb.append(" ");
                }
            }
            sb.append("} ");
            sb.append("resourceOwner={").append(this.resourceOwner).append("} ");
            sb.append("action={").append(this.action).append("} ");
            sb.append("accessTypes=[");
            if (this.accessTypes != null) {
                for (String accessType : this.accessTypes) {
                    sb.append(accessType).append(" ");
                }
            }
            sb.append("] ");
            sb.append("}");
            return sb;
        }
    }
}

