/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.ranger.raz.model.RangerRazRequestBase;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerRazMultiOperationRequest
extends RangerRazRequestBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<RangerRazRequestBase.ResourceAccess> operations;

    public RangerRazMultiOperationRequest() {
    }

    public RangerRazMultiOperationRequest(String serviceType, RangerRazRequestBase.ResourceAccess operation, String user) {
        this.setServiceType(serviceType);
        this.setUser(user);
        this.setAccessTime(new Date());
        this.addOperation(operation);
    }

    public List<RangerRazRequestBase.ResourceAccess> getOperations() {
        return this.operations;
    }

    public void setOperations(List<RangerRazRequestBase.ResourceAccess> operations) {
        this.operations = operations;
    }

    @JsonIgnore
    public void addOperation(RangerRazRequestBase.ResourceAccess operation) {
        List<RangerRazRequestBase.ResourceAccess> operations = this.operations;
        if (operations == null) {
            this.operations = operations = new ArrayList<RangerRazRequestBase.ResourceAccess>();
        }
        operations.add(operation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerRazMultiOperationRequest={");
        super.toString(sb);
        sb.append("operations=[");
        if (this.operations != null) {
            for (RangerRazRequestBase.ResourceAccess operation : this.operations) {
                operation.toString(sb).append(" ");
            }
        }
        sb.append("]");
        sb.append("}");
        return sb;
    }
}

