/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.ranger.raz.model.RangerRazIdentityMappings;

public class RangerRazIdentityMappingsUtil {
    private final Map<String, String> userClusterIdToCloudId = new HashMap<String, String>();
    private final Map<String, String> userCloudIdToClusterId = new HashMap<String, String>();
    private final Map<String, String> groupClusterIdToCloudId = new HashMap<String, String>();
    private final Map<String, String> groupCloudIdToClusterId = new HashMap<String, String>();
    private final Long version;

    public RangerRazIdentityMappingsUtil(RangerRazIdentityMappings idMappings) {
        if (MapUtils.isNotEmpty(idMappings.getUserClusterIdToCloudId())) {
            this.userClusterIdToCloudId.putAll(idMappings.getUserClusterIdToCloudId());
        }
        for (Map.Entry<String, String> entry : this.userClusterIdToCloudId.entrySet()) {
            this.userCloudIdToClusterId.put(entry.getValue(), entry.getKey());
        }
        if (MapUtils.isNotEmpty(idMappings.getGroupClusterIdToCloudId())) {
            this.groupClusterIdToCloudId.putAll(idMappings.getGroupClusterIdToCloudId());
        }
        for (Map.Entry<String, String> entry : this.groupClusterIdToCloudId.entrySet()) {
            this.groupCloudIdToClusterId.put(entry.getValue(), entry.getKey());
        }
        this.version = idMappings.getVersion();
    }

    public String getUserCloudId(String clusterId) {
        return this.userClusterIdToCloudId.get(clusterId);
    }

    public String getUserClusterId(String cloudId) {
        return this.userCloudIdToClusterId.get(cloudId);
    }

    public String getGroupCloudId(String groupClusterId) {
        return this.groupClusterIdToCloudId.get(groupClusterId);
    }

    public String getGroupClusterId(String groupCloudId) {
        return this.groupCloudIdToClusterId.get(groupCloudId);
    }

    public Long getVersion() {
        return this.version;
    }
}

