/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.intg.token;

import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.raz.intg.token.TokenRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwTokenRetrieverEnv
implements TokenRetriever<String> {
    private static final Logger LOG = LoggerFactory.getLogger(JwTokenRetrieverEnv.class);
    private static final String RANGER_PROP_JWT_ENV_VAR_NAME = "ranger.auth.jwt.env.var.name";
    public static final String DEFAULT_JWT_ENV_VAR_NAME = "RAZ_AUTH_JWT";
    private String jwtEnvVarName;

    public JwTokenRetrieverEnv(Configuration config) {
        this.init(config);
    }

    private void init(Configuration config) {
        String envName;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> JwTokenRetrieverEnv.init()");
        }
        if (StringUtils.isNotBlank((String)(envName = config.get(RANGER_PROP_JWT_ENV_VAR_NAME, DEFAULT_JWT_ENV_VAR_NAME)))) {
            this.jwtEnvVarName = envName;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== JwTokenRetrieverEnv.init(): jwtEnvVarName=" + this.jwtEnvVarName);
        }
    }

    @Override
    public Optional<String> retrieve() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> JwTokenRetrieverEnv.retrieve()");
        }
        Optional<String> ret = Optional.empty();
        try {
            String jwt = System.getenv(this.jwtEnvVarName);
            if (StringUtils.isNotBlank((String)jwt)) {
                ret = Optional.of(jwt);
            }
        }
        catch (Exception e) {
            LOG.error("JwTokenRetrieverEnv.retrieve(): Failed to get JWT token.", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== JwTokenRetrieverEnv.retrieve(): isJwTokenPresent=" + ret.isPresent());
        }
        return ret;
    }
}

