/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.intg.client.executor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.ws.rs.core.Cookie;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.raz.intg.RangerRazErrorCode;
import org.apache.ranger.raz.intg.RangerRazException;
import org.apache.ranger.raz.intg.client.RangerRazClientLogger;
import org.apache.ranger.raz.intg.client.executor.HttpClientExecutor;
import org.apache.ranger.raz.intg.client.executor.RestClientExecutor;
import org.apache.ranger.raz.intg.client.executor.RestClientExecutorConfig;
import org.apache.ranger.raz.intg.token.TokenRetriever;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientExecutorJersey
implements RestClientExecutor<Client>,
HttpClientExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RestClientExecutorJersey.class);
    private volatile Client client;
    private final RestClientExecutorConfig clientConfig;
    private final Gson gsonBuilder;
    private TokenRetriever<String> tokenRetriever = null;
    private String jwtServerCookieName = null;
    private final Configuration configuration;
    private boolean ignoreJwtIfAuthExists = false;

    public RestClientExecutorJersey(RestClientExecutorConfig config, Configuration configuration) {
        this.clientConfig = config;
        this.gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getClient() {
        Client result = this.client;
        if (result == null) {
            RestClientExecutorJersey restClientExecutorJersey = this;
            synchronized (restClientExecutorJersey) {
                result = this.client;
                if (result == null) {
                    this.client = result = this.build();
                }
            }
        }
        return result;
    }

    @Override
    public Client build() {
        DefaultClientConfig config;
        Client ret = null;
        if (this.clientConfig.isSsl()) {
            config = new DefaultClientConfig();
            config.getClasses().add(JacksonJsonProvider.class);
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return session.getPeerHost().equals(urlHostName);
                }
            };
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hv, this.clientConfig.getSslContext()));
            ret = Client.create((ClientConfig)config);
        }
        if (ret == null) {
            config = new DefaultClientConfig();
            config.getClasses().add(JacksonJsonProvider.class);
            ret = Client.create((ClientConfig)config);
        }
        if (StringUtils.isNotEmpty((String)this.clientConfig.getUsername()) && StringUtils.isNotEmpty((String)this.clientConfig.getPassword())) {
            ret.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.clientConfig.getUsername(), this.clientConfig.getPassword()));
        }
        ret.setConnectTimeout(this.clientConfig.getRestClientConnTimeOutMs());
        ret.setReadTimeout(this.clientConfig.getRestClientReadTimeOutMs());
        boolean isJwtFetcherEnabled = this.configuration.getBoolean("ranger.raz.client.auth.jwt.enabled", Boolean.parseBoolean("true"));
        if (isJwtFetcherEnabled) {
            this.jwtServerCookieName = this.clientConfig.getJwtServerCookieName();
            if (StringUtils.isBlank((String)this.jwtServerCookieName)) {
                this.jwtServerCookieName = "hadoop-jwt";
            }
            try {
                this.tokenRetriever = this.getJwtTokenRetriever(this.configuration);
            }
            catch (Exception e) {
                LOG.error("RestClientExecutorJersey.build(): Failed to initialize JWT token retriever.", (Throwable)e);
            }
        } else {
            LOG.warn("RestClientExecutorJersey.build(): Skipping JWT fetcher, use property 'ranger.raz.client.auth.jwt.enabled' to enable.");
        }
        this.ignoreJwtIfAuthExists = this.configuration.getBoolean("ranger.raz.client.auth.jwt.ignoreif.other.auth.exists", this.ignoreJwtIfAuthExists);
        return ret;
    }

    @Override
    public <T> T getAndParse(String url, Map<String, String> queryParams, Class<T> clazz) throws Exception {
        ClientResponse resp = (ClientResponse)this.getWebResourceBuilder(url, queryParams).get(ClientResponse.class);
        return this.parseResponse(resp, clazz);
    }

    @Override
    public <T> T postAndParse(String url, Map<String, String> queryParams, Object obj, Class<T> clazz) throws Exception {
        ClientResponse resp = (ClientResponse)this.getWebResourceBuilder(url, queryParams).post(ClientResponse.class, (Object)this.gsonBuilder.toJson(obj));
        return this.parseResponse(resp, clazz);
    }

    @Override
    public <T> T putAndParse(String url, Map<String, String> queryParams, Object obj, Class<T> clazz) throws Exception {
        ClientResponse resp = (ClientResponse)this.getWebResourceBuilder(url, queryParams).put(ClientResponse.class, (Object)this.gsonBuilder.toJson(obj));
        return this.parseResponse(resp, clazz);
    }

    @Override
    public <T> T deleteAndParse(String url, Map<String, String> queryParams, Class<T> clazz) throws Exception {
        ClientResponse resp = (ClientResponse)this.getWebResourceBuilder(url, queryParams).delete(ClientResponse.class);
        return this.parseResponse(resp, clazz);
    }

    private WebResource.Builder getWebResourceBuilder(String url, Map<String, String> queryParams) {
        WebResource webResource = this.getClient().resource(url);
        webResource = this.setQueryParams(webResource, queryParams);
        WebResource.Builder builder = (WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json");
        return builder;
    }

    private WebResource setQueryParams(WebResource webResource, Map<String, String> queryParams) {
        WebResource ret = webResource;
        WebResource.Builder builder = ret.getRequestBuilder();
        if (!this.isDtOperation(queryParams)) {
            builder = this.handleJwt(builder, queryParams);
        } else {
            LOG.info("Skipping JWT, as this is a RAZ Delegation token operation.");
        }
        if (webResource != null && queryParams != null) {
            Set<Map.Entry<String, String>> entrySet = queryParams.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                ret = ret.queryParam(entry.getKey(), entry.getValue());
            }
        }
        return ret;
    }

    private WebResource.Builder handleJwt(WebResource.Builder builder, Map<String, String> queryParams) {
        if (!(this.isDtOperation(queryParams) || this.ignoreJwtIfAuthExists && this.otherAuthCredExists(queryParams))) {
            if (this.tokenRetriever != null) {
                Optional<String> jwtOptional = this.tokenRetriever.retrieve();
                if (jwtOptional.isPresent()) {
                    builder.cookie(new Cookie(this.jwtServerCookieName, jwtOptional.get()));
                }
            } else {
                LOG.warn("RestClientExecutorJersey.handleJwt(): Since JWTokenRetriver init failed, skipping JWT auth.");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("RestClientExecutorJersey.handleJwt(): Skipping JWT as required condition does not meet.");
            LOG.debug("RestClientExecutorJersey.handleJwt(): [isDtOperation(queryParams)={}], [ignoreJwtIfAuthExists={}], [otherAuthCredExists(queryParams)={}]", new Object[]{this.isDtOperation(queryParams), this.ignoreJwtIfAuthExists, this.otherAuthCredExists(queryParams)});
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R parseResponse(ClientResponse response, Class<R> clazz) throws RangerRazException {
        Object type;
        block11: {
            type = null;
            if (response != null) {
                try {
                    if (response.getStatus() == 200) {
                        type = response.getEntity(clazz);
                        break block11;
                    }
                    int httpStatus = response.getStatus();
                    RangerRazClientLogger.error(LOG, "Request failed : response=[{}], response.status={}", (Object)response, (Object)httpStatus);
                    if (httpStatus == 403 || httpStatus == 401) {
                        throw new RangerRazException(RangerRazErrorCode.RAZ_CLIENT_ACCESS_DENIED, new Object[0]);
                    }
                    if (httpStatus == 401) {
                        LOG.warn("Server did not process this request due to in-sufficient auth details.");
                        throw new RangerRazException(RangerRazErrorCode.RAZ_CLIENT_UNAUTHORIZED_ACCESS, new Object[0]);
                    }
                    throw new RangerRazException(RangerRazErrorCode.RAZ_CLIENT_REQUEST_FAILED, httpStatus);
                }
                finally {
                    try {
                        response.close();
                    }
                    catch (Exception exception) {}
                }
            }
            RangerRazClientLogger.error(LOG, "Received NULL response from server.");
            throw new RangerRazException(RangerRazErrorCode.RAZ_CLIENT_REQUEST_FAILED, new Object[0]);
        }
        return (R)type;
    }
}

