/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.intg.client.executor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.ranger.raz.intg.RangerRazErrorCode;
import org.apache.ranger.raz.intg.RangerRazException;
import org.apache.ranger.raz.intg.client.RangerRazClientLogger;
import org.apache.ranger.raz.intg.client.executor.HttpClientExecutor;
import org.apache.ranger.raz.intg.client.executor.RestClientExecutor;
import org.apache.ranger.raz.intg.client.executor.RestClientExecutorConfig;
import org.apache.ranger.raz.intg.token.TokenRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientExecutorApacheHttp
implements RestClientExecutor<CloseableHttpClient>,
HttpClientExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RestClientExecutorApacheHttp.class);
    private static final String PROTOCOL_HTTPS = "https";
    private static final String RESPONSE_ETAG = "ETag";
    private volatile CloseableHttpClient httpClient;
    private final RestClientExecutorConfig clientConfig;
    private final Gson gsonBuilder;
    private TokenRetriever<String> tokenRetriever = null;
    private String jwtServerCookieName = null;
    private final Configuration configuration;
    private boolean ignoreJwtIfAuthExists = false;

    public RestClientExecutorApacheHttp(RestClientExecutorConfig config, Configuration configuration) {
        this.clientConfig = config;
        this.gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
        this.configuration = configuration;
    }

    public void resetClient() {
        this.httpClient = null;
    }

    @Override
    public CloseableHttpClient build() {
        PoolingHttpClientConnectionManager connectionManager;
        Registry authRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true, true)).build();
        HttpClientBuilder clientBuilder = HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)authRegistry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("===>> Building apache HTTP client with configs={}", (Object)this.clientConfig);
        }
        try {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (this.isKerberosAuthenticated()) {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new KerberosCredentials(null));
            } else if (StringUtils.isNotEmpty((String)this.clientConfig.getUsername()) && StringUtils.isNotEmpty((String)this.clientConfig.getPassword())) {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.clientConfig.getUsername(), this.clientConfig.getPassword()));
            }
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        catch (Exception excp) {
            LOG.error("Exception while adding credentials, skipping setting credentials for client.", (Throwable)excp);
        }
        if (this.clientConfig.isSsl()) {
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(this.clientConfig.getSslContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register(PROTOCOL_HTTPS, (Object)sslsf).build();
            connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        } else {
            connectionManager = new PoolingHttpClientConnectionManager();
        }
        connectionManager.setMaxTotal(this.clientConfig.getMaxConnections().intValue());
        connectionManager.setDefaultMaxPerRoute(this.clientConfig.getMaxConnectionsPerHost().intValue());
        connectionManager.setValidateAfterInactivity(this.clientConfig.getValidateAfterInactivityMs().intValue());
        RequestConfig customizedRequestConfig = RequestConfig.custom().setCookieSpec("default").setConnectTimeout(this.clientConfig.getRestClientConnTimeOutMs().intValue()).setSocketTimeout(this.clientConfig.getRestClientReadTimeOutMs().intValue()).build();
        CloseableHttpClient httpClient = clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryHandler((HttpRequestRetryHandler)new RazRetryHandlerApacheHttp(this.clientConfig.getPoolRetryCount(), true)).setDefaultRequestConfig(customizedRequestConfig).build();
        boolean isJwtFetcherEnabled = this.configuration.getBoolean("ranger.raz.client.auth.jwt.enabled", Boolean.parseBoolean("true"));
        if (isJwtFetcherEnabled) {
            this.jwtServerCookieName = this.clientConfig.getJwtServerCookieName();
            if (StringUtils.isBlank((String)this.jwtServerCookieName)) {
                this.jwtServerCookieName = "hadoop-jwt";
            }
            try {
                this.tokenRetriever = this.getJwtTokenRetriever(this.configuration);
            }
            catch (Exception e) {
                LOG.error("RestClientExecutorApacheHttp.build(): Failed to initialize JWT token retriever.", (Throwable)e);
            }
        } else {
            LOG.warn("RestClientExecutorApacheHttp.build(): Skipping JWT fetcher, use property 'ranger.raz.client.auth.jwt.enabled' to enable.");
        }
        this.ignoreJwtIfAuthExists = this.configuration.getBoolean("ranger.raz.client.auth.jwt.ignoreif.other.auth.exists", this.ignoreJwtIfAuthExists);
        return httpClient;
    }

    @Override
    public <T> T getAndParse(String url, Map<String, String> queryParams, Class<T> clazz) throws Exception {
        HttpGet httpGet = new HttpGet(this.buildURI(url, queryParams));
        return this.executeAndParseResponse(httpGet, clazz, queryParams);
    }

    @Override
    public <T> T postAndParse(String url, Map<String, String> queryParams, Object obj, Class<T> clazz) throws Exception {
        HttpPost httpPost = new HttpPost(this.buildURI(url, queryParams));
        StringEntity entity = new StringEntity(this.gsonBuilder.toJson(obj), StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        return this.executeAndParseResponse(httpPost, clazz, queryParams);
    }

    @Override
    public <T> T putAndParse(String url, Map<String, String> queryParams, Object obj, Class<T> clazz) throws Exception {
        HttpPut httpPut = new HttpPut(this.buildURI(url, queryParams));
        StringEntity entity = new StringEntity(this.gsonBuilder.toJson(obj), StandardCharsets.UTF_8);
        httpPut.setEntity((HttpEntity)entity);
        return this.executeAndParseResponse(httpPut, clazz, queryParams);
    }

    @Override
    public <T> T deleteAndParse(String url, Map<String, String> queryParams, Class<T> clazz) throws Exception {
        HttpDelete httpDelete = new HttpDelete(this.buildURI(url, queryParams));
        return this.executeAndParseResponse(httpDelete, clazz, queryParams);
    }

    private <R> R parseResponse(HttpResponse response, Class<R> clazz) throws RangerRazException, UnsupportedOperationException, IOException {
        Object type = null;
        if (response != null) {
            int httpStatus = response.getStatusLine().getStatusCode();
            String contentType = "";
            if (response.getEntity().getContentType() != null) {
                contentType = response.getEntity().getContentType().getValue();
            }
            if (httpStatus != 200) {
                RangerRazClientLogger.error(LOG, "Request failed : response=[{}], response.status={}", (Object)response, (Object)httpStatus);
                HashMap<String, String> exceptionHeaders = new HashMap<String, String>();
                String errorMessage = "";
                Header[] headerArray = null;
                try (InputStream responseInputStream = response.getEntity().getContent();){
                    errorMessage = IOUtils.toString((InputStream)responseInputStream, (Charset)Charset.defaultCharset());
                }
                catch (Throwable object) {
                    headerArray = object;
                    throw object;
                }
                if (contentType.equals("application/json")) {
                    String responseTag = null;
                    if (response.containsHeader(RESPONSE_ETAG)) {
                        responseTag = response.getFirstHeader(RESPONSE_ETAG).getValue();
                    }
                    String string = responseTag = responseTag != null ? responseTag.replace("\"", "") : null;
                    if (responseTag != null && responseTag.equals("webApplicationExcp_with_headers")) {
                        for (Header header : response.getAllHeaders()) {
                            exceptionHeaders.put(header.getName(), header.getValue());
                        }
                    }
                }
                RangerRazException rangerRazException = new RangerRazException(errorMessage + "; HttpStatus: " + httpStatus);
                if (httpStatus == 403) {
                    rangerRazException.setErrorCode(RangerRazErrorCode.RAZ_CLIENT_ACCESS_DENIED);
                } else if (httpStatus == 401) {
                    LOG.warn("Server did not process this request due to in-sufficient auth details.");
                    rangerRazException.setErrorCode(RangerRazErrorCode.RAZ_CLIENT_UNAUTHORIZED_ACCESS);
                } else {
                    rangerRazException.setErrorCode(RangerRazErrorCode.RAZ_CLIENT_REQUEST_FAILED);
                }
                rangerRazException.setRangerRazExceptionHeadersMap(exceptionHeaders);
                throw rangerRazException;
            }
        } else {
            RangerRazClientLogger.error(LOG, "Received NULL response from server.");
            throw new RangerRazException(RangerRazErrorCode.RAZ_CLIENT_REQUEST_FAILED, new Object[0]);
        }
        InputStream responseInputStream = response.getEntity().getContent();
        type = clazz.equals(String.class) ? IOUtils.toString((InputStream)responseInputStream, (Charset)Charset.defaultCharset()) : this.gsonBuilder.fromJson((Reader)new InputStreamReader(responseInputStream), clazz);
        responseInputStream.close();
        return (R)type;
    }

    private URI buildURI(String url, Map<String, String> queryParams) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(url);
        if (queryParams != null) {
            for (Map.Entry<String, String> param : queryParams.entrySet()) {
                builder.addParameter(param.getKey(), param.getValue());
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpClient getCloseableHttpClient() {
        CloseableHttpClient result = this.httpClient;
        if (result == null) {
            RestClientExecutorApacheHttp restClientExecutorApacheHttp = this;
            synchronized (restClientExecutorApacheHttp) {
                result = this.httpClient;
                if (result == null) {
                    this.httpClient = result = this.build();
                }
            }
        }
        return result;
    }

    private <T extends HttpRequestBase> T addCommonHeaders(T t, Map<String, String> queryParams) {
        t.addHeader("Accept", "application/json");
        t.setHeader("Content-type", "application/json");
        t = this.handleJwt(t, queryParams);
        return t;
    }

    private <T extends HttpRequestBase> T handleJwt(T t, Map<String, String> queryParams) {
        if (!(this.isDtOperation(queryParams) || this.ignoreJwtIfAuthExists && this.otherAuthCredExists(queryParams))) {
            if (this.tokenRetriever != null) {
                Optional<String> jwtOptional = this.tokenRetriever.retrieve();
                if (jwtOptional.isPresent()) {
                    StringBuffer jwtWithCookieName = new StringBuffer();
                    jwtWithCookieName.append(this.jwtServerCookieName);
                    jwtWithCookieName.append("=");
                    jwtWithCookieName.append(jwtOptional.get());
                    t.setHeader("Cookie", jwtWithCookieName.toString());
                }
            } else {
                LOG.warn("RestClientExecutorApacheHttp.handleJwt(): Since JWTokenRetriver init failed, skipping JWT auth.");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("RestClientExecutorApacheHttp.handleJwt(): Skipping JWT as required condition does not meet.");
            LOG.debug("RestClientExecutorApacheHttp.handleJwt(): [isDtOperation(queryParams)={}], [ignoreJwtIfAuthExists={}], [otherAuthCredExists(queryParams)={}]", new Object[]{this.isDtOperation(queryParams), this.ignoreJwtIfAuthExists, this.otherAuthCredExists(queryParams)});
        }
        return t;
    }

    private <T extends HttpRequestBase, R> R executeAndParseResponse(T request, Class<R> responseClazz, Map<String, String> queryParams) throws Exception {
        R ret = null;
        CloseableHttpClient client = this.getCloseableHttpClient();
        if (client != null) {
            this.addCommonHeaders(request, queryParams);
            try (CloseableHttpResponse response = client.execute(request);){
                ret = this.parseResponse((HttpResponse)response, responseClazz);
            }
        } else {
            RangerRazClientLogger.error(LOG, "Can not procees request as client is null.");
        }
        return ret;
    }

    private class RazRetryHandlerApacheHttp
    extends StandardHttpRequestRetryHandler {
        public RazRetryHandlerApacheHttp(Integer poolRetryCount, boolean isIdempotentRequest) {
            super(poolRetryCount.intValue(), isIdempotentRequest);
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("===>> RazRetryHandlerApacheHttp.retryRequest({},{})", (Object)exception.getMessage(), (Object)executionCount);
            }
            boolean ret = super.retryRequest(exception, executionCount, context);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<<=== RazRetryHandlerApacheHttp.retryRequest(): ret={}", (Object)ret);
            }
            return ret;
        }
    }
}

