/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.intg.client.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.raz.intg.token.TokenRetriever;

public interface RestClientExecutor<C> {
    public static final String REST_ACCEPTED_MIME_TYPE_JSON = "application/json";
    public static final String REST_CONTENT_TYPE_MIME_TYPE_JSON = "application/json";
    public static final String REST_HEADER_ACCEPT = "Accept";
    public static final String REST_HEADER_CONTENT_TYPE = "Content-type";
    public static final String GSON_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String JWT_COOKIE_NAME_DEFAULT = "hadoop-jwt";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String RANGER_PROP_JWT_TOKEN_RETRIEVER_CLASS = "ranger.raz.client.auth.jwt.retriever.class";
    public static final String RANGER_PROP_JWT_TOKEN_RETRIEVER_CLASS_DEFAULT = "org.apache.ranger.raz.intg.token.JwTokenRetrieverEnv";
    public static final String RANGER_PROP_JWT_ENABLED = "ranger.raz.client.auth.jwt.enabled";
    public static final String RANGER_PROP_JWT_IGNOREIF_OTHER_AUTH_EXISTS = "ranger.raz.client.auth.jwt.ignoreif.other.auth.exists";
    public static final String RANGER_PROP_JWT_ENABLED_DEFAULT = "true";
    public static final String RANGER_PROP_AUTH_TYPE = "AUTH_TYPE";
    public static final String RANGER_AUTH_TYPE_KERBEROS = "KERBEROS";
    public static final String RANGER_AUTH_TYPE_RAZ_DT = "RAZ-DT";
    public static final String RANGER_PROP_DT_OPERATION_TYPE = "DT_OPERATION_TYPE";
    public static final String RANGER_DT_OPERATION_TYPE_GET = "GETDELEGATIONTOKEN";
    public static final String RANGER_DT_OPERATION_TYPE_RENEW = "RENEWDELEGATIONTOKEN";
    public static final String RANGER_DT_OPERATION_TYPE_CANCEL = "CANCELDELEGATIONTOKEN";

    public C build();

    default public List<String> getURLs(String configURLs) {
        ArrayList<String> configuredURLs = new ArrayList<String>();
        if (configURLs != null) {
            String[] urls;
            for (String strUrl : urls = configURLs.split(",")) {
                if (StringUtils.isEmpty((String)StringUtils.trimToEmpty((String)strUrl))) continue;
                if (strUrl.endsWith("/")) {
                    strUrl = strUrl.substring(0, strUrl.length() - 1);
                }
                configuredURLs.add(strUrl);
            }
        }
        return configuredURLs;
    }

    default public boolean isKerberosAuthenticated() throws Exception {
        boolean status = false;
        try {
            UserGroupInformation loggedInUser = UserGroupInformation.getLoginUser();
            boolean isSecurityEnabled = UserGroupInformation.isSecurityEnabled();
            boolean hasKerberosCredentials = loggedInUser.hasKerberosCredentials();
            UserGroupInformation.AuthenticationMethod loggedInUserAuthMethod = loggedInUser.getAuthenticationMethod();
            status = isSecurityEnabled && hasKerberosCredentials && loggedInUserAuthMethod.equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS);
        }
        catch (IOException e) {
            throw new Exception("Failed to get authentication details.", e);
        }
        return status;
    }

    default public TokenRetriever<String> getJwtTokenRetriever(Configuration configuration) throws Exception {
        String clsName = configuration.get(RANGER_PROP_JWT_TOKEN_RETRIEVER_CLASS, RANGER_PROP_JWT_TOKEN_RETRIEVER_CLASS_DEFAULT);
        ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
        TokenRetriever ret = null;
        Class<?> cls = clsLoader.loadClass(clsName.trim());
        ret = (TokenRetriever)cls.getConstructor(Configuration.class).newInstance(configuration);
        return ret;
    }

    default public boolean otherAuthCredExists(Map<String, String> queryParams) {
        String authType;
        boolean ret = false;
        if (queryParams != null && !queryParams.isEmpty() && StringUtils.isNotBlank((String)(authType = queryParams.get(RANGER_PROP_AUTH_TYPE)))) {
            ret = true;
        }
        return ret;
    }

    default public boolean isDtOperation(Map<String, String> queryParams) {
        String authType;
        boolean ret = false;
        if (queryParams != null && !queryParams.isEmpty() && StringUtils.isNotBlank((String)(authType = queryParams.get(RANGER_PROP_DT_OPERATION_TYPE)))) {
            ret = true;
        }
        return ret;
    }
}

