/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.intg.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.raz.intg.RangerRazErrorCode;
import org.apache.ranger.raz.intg.RangerRazException;
import org.apache.ranger.raz.intg.client.RangerRESTClient;
import org.apache.ranger.raz.intg.client.RangerRazClientLogger;
import org.apache.ranger.raz.model.RangerRazIdentityMappings;
import org.apache.ranger.raz.model.RangerRazIdentityMappingsUtil;
import org.apache.ranger.raz.model.RangerRazMultiOperationRequest;
import org.apache.ranger.raz.model.RangerRazMultiOperationResult;
import org.apache.ranger.raz.model.RangerRazRequest;
import org.apache.ranger.raz.model.RangerRazResult;
import org.apache.ranger.raz.model.RangerRazResultBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerRazClient {
    private static final Logger LOG = LoggerFactory.getLogger(RangerRazClient.class);
    public static final String HTTP_URL_SEPARATOR = "/";
    public static final String RAZ_CLIENT_PREFIX_KEY = "ranger.raz.client.prefix";
    public static final String RAZ_CLIENT_PREFIX_DEFAULT = "ranger.raz.client.";
    public static final String RAZ_SSL_FILE_LOC = "rest.ssl.config.file";
    public static final String RAZ_CLIENT_CONN_TIMEOUT_MS = "rest.client.connection.timeoutMs";
    public static final String RAZ_CLIENT_READ_TIMEOUT_MS = "rest.client.read.timeoutMs";
    public static final String RAZ_REST_HOST_URL = "rest.host.url";
    public static final String RAZ_CLIENT_LOG_QUIET_MODE = "log.quiet.mode";
    public static final String MASKED_TOKEN_STR = "********";
    public static final String RAZ_REST_OID_API = "rest.oid.map.url";
    public static final String RAZ_CLIENT_SKIP_MASK_FOR_FIRST_KEY = "client.skip.mask.for.first";
    public static final String RAZ_CLIENT_KEYS_TO_REDACT_PROP = "keys.to.redact";
    public static Set<String> RAZ_CLIENT_KEYS_TO_REDACT = new HashSet<String>(Arrays.asList("ADLS_DSAS", "S3_SIGN_REQUEST", "S3_SIGN_RESPONSE"));
    private static final String PARAM_OP = "op";
    private static final String PARAM_RENEWER = "renewer";
    private static final String PARAM_TOKEN = "token";
    private static final String PARAM_DELEGATION = "delegation";
    private static final String PARAM_DOAS = "doAs";
    private static final String PARAM_DT_SERVICENAME = "service";
    private static final String OP_GETDELEGATIONTOKEN = "GETDELEGATIONTOKEN";
    private static final String OP_RENEWDELEGATIONTOKEN = "RENEWDELEGATIONTOKEN";
    private static final String OP_CANCELDELEGATIONTOKEN = "CANCELDELEGATIONTOKEN";
    private static final String RAZ_API_SINGLE_RESOURCE = "/api/authz/%s/access";
    private static final String RAZ_API_MULTI_RESOURCE = "/api/authz/%s/accesses";
    private static final String RAZ_API_DOWNLOAD_OID_MAP = "/api/authz/identity-mappings";
    private static final String DEFAULT_DT_SERVICE_NAME = "RANGER_RAZ";
    private static final int DEFAULT_RAZ_SERVER_PORT = 6181;
    private static final Object DUMMY_POST_PARAM = new Object();
    private static Long latestRazIdMappingVersion = -1L;
    private static int RAZ_CLIENT_SKIP_MASK_FOR_FIRST_DEFAULT = 5;
    private final ObjectMapper mapper = new ObjectMapper();
    private final RangerRESTClient restClient;
    private final UserGroupInformation ugi;
    private final String dtServiceName;
    private RangerRazIdentityMappingsUtil razIdMappUtil = null;
    private static final RangerRazException MISSING_KERBEROS_GET_DT = new RangerRazException(RangerRazErrorCode.RAZ_CLIENT_UNAUTHORIZED_ACCESS, "Kerberos Authentication is Required, to get RAZ delegation token");
    private static final RangerRazException MISSING_KERBEROS_RENEW_DT = new RangerRazException(RangerRazErrorCode.RAZ_CLIENT_UNAUTHORIZED_ACCESS, "Kerberos Authentication is Required, to renew RAZ delegaton token");
    private static final RangerRazException MISSING_KERBEROS_CANCEL_DT = new RangerRazException(RangerRazErrorCode.RAZ_CLIENT_UNAUTHORIZED_ACCESS, "Kerberos Authentication is Required, to cancel RAZ delegation token");

    private RangerRazClient(Configuration configuration, UserGroupInformation ugi) throws IOException {
        Object[] keys;
        String errorMsg;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazClient()");
        }
        String confPrefix = configuration.get(RAZ_CLIENT_PREFIX_KEY, RAZ_CLIENT_PREFIX_DEFAULT);
        String sslConfigFileName = configuration.get(confPrefix + RAZ_SSL_FILE_LOC);
        int restClientConnTimeOutMs = configuration.getInt(confPrefix + RAZ_CLIENT_CONN_TIMEOUT_MS, 120000);
        int restClientReadTimeOutMs = configuration.getInt(confPrefix + RAZ_CLIENT_READ_TIMEOUT_MS, 30000);
        int maxConnections = configuration.getInt(confPrefix + "rest.client.connection.pool.max", 10);
        int maxConnectionsPerHost = configuration.getInt(confPrefix + "rest.client.connection.pool.max-per-host", 10);
        int validateAfterInactivityMs = configuration.getInt(confPrefix + "rest.client.connection.pool.validate-after-inactivity", 2000);
        int poolRetryCount = configuration.getInt(confPrefix + "rest.client.connection.pool.retry-count", 3);
        String razURL = configuration.get(confPrefix + RAZ_REST_HOST_URL);
        String initialzationError = null;
        RangerRazClientLogger.setIsQuietMode(configuration.getBoolean(confPrefix + RAZ_CLIENT_LOG_QUIET_MODE, true));
        this.ugi = ugi;
        if (ugi == null) {
            errorMsg = "no user is logged in";
            RangerRazClientLogger.error(LOG, "RangerRazClient(): {}", (Object)errorMsg);
            String string = initialzationError = initialzationError == null ? errorMsg : initialzationError + ", " + errorMsg;
        }
        if (StringUtils.isBlank((String)razURL)) {
            errorMsg = "configuration '" + confPrefix + RAZ_REST_HOST_URL + "' is not set";
            RangerRazClientLogger.error(LOG, "RangerRazClient(): {}", (Object)errorMsg);
            String string = initialzationError = initialzationError == null ? errorMsg : initialzationError + ", " + errorMsg;
        }
        if (initialzationError != null) {
            throw new IOException("RangerRazClient initialization failed: " + initialzationError);
        }
        boolean useLocalRazService = configuration.getBoolean(confPrefix + "client.use.local.raz", false);
        RAZ_CLIENT_SKIP_MASK_FOR_FIRST_DEFAULT = configuration.getInt(confPrefix + RAZ_CLIENT_SKIP_MASK_FOR_FIRST_KEY, RAZ_CLIENT_SKIP_MASK_FOR_FIRST_DEFAULT);
        String redactKeys = configuration.get(confPrefix + RAZ_CLIENT_KEYS_TO_REDACT_PROP);
        if (StringUtils.isNotEmpty((String)redactKeys) && ArrayUtils.isNotEmpty((Object[])(keys = redactKeys.split(",")))) {
            RAZ_CLIENT_KEYS_TO_REDACT = new HashSet<Object>(Arrays.asList(keys));
        }
        this.restClient = new RangerRESTClient(razURL, sslConfigFileName, configuration, useLocalRazService);
        this.restClient.setRestClientConnTimeOutMs(restClientConnTimeOutMs);
        this.restClient.setRestClientReadTimeOutMs(restClientReadTimeOutMs);
        this.restClient.setmMaxConnections(maxConnections);
        this.restClient.setMaxConnectionsPerHost(maxConnectionsPerHost);
        this.restClient.setValidateAfterInactivityMs(validateAfterInactivityMs);
        this.restClient.setPoolRetryCount(poolRetryCount);
        this.dtServiceName = RangerRazClient.getDTServiceName(this.restClient.getConfiguredURLs());
        if (LOG.isDebugEnabled()) {
            String propPrefix = configuration.get(RAZ_CLIENT_PREFIX_KEY, RAZ_CLIENT_PREFIX_DEFAULT);
            Map propMap = configuration.getPropsWithPrefix(propPrefix);
            for (Map.Entry prop : propMap.entrySet()) {
                LOG.debug("RangerRazClient.init(): config: {}={}", prop.getKey(), prop.getValue());
            }
            UserGroupInformation.logAllUserInfo((Logger)LOG, (UserGroupInformation)ugi);
            LOG.debug("RangerRazClient(): dtServiceName={}", (Object)this.dtServiceName);
            LOG.debug("<== RangerRazClient()");
        }
    }

    public static RangerRazClient getInstance(Configuration configuration, UserGroupInformation ugi) throws IOException {
        RangerRazClient instance = new RangerRazClient(configuration, ugi);
        return instance;
    }

    public String getDelegationTokenServiceName() {
        return this.dtServiceName;
    }

    public String getDelegationToken(String renewer) throws RangerRazException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazClient.getDelegationToken(renewer={})", (Object)renewer);
        }
        String ret = "";
        String maskedDelegationToken = null;
        if (this.isKerberosAuthenticated()) {
            Map<String, String> queryParams = this.constructMap(PARAM_OP, OP_GETDELEGATIONTOKEN, PARAM_RENEWER, renewer, PARAM_DT_SERVICENAME, this.dtServiceName, "AUTH_TYPE", "KERBEROS", "DT_OPERATION_TYPE", OP_GETDELEGATIONTOKEN);
            UserGroupInformation user = this.getUgi(queryParams);
            PrivilegedExceptionAction<String> action = this.getPrivilegedAction(RangerRESTClient.HTTP_METHOD.GET, "", queryParams, DUMMY_POST_PARAM, String.class);
            String response = this.executeAction(action, user);
            JsonNode node = this.getJsonNode(response, "urlString");
            ret = node.asText();
            if (StringUtils.isNotBlank((String)ret)) {
                maskedDelegationToken = MASKED_TOKEN_STR;
            }
        } else {
            LOG.error("Kerberos Authentication is Required, to get RAZ delegation token.");
            throw MISSING_KERBEROS_GET_DT;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRazClient.getDelegationToken(renewer={}): delegationToken=[{}]", (Object)renewer, (Object)maskedDelegationToken);
        }
        return ret;
    }

    public Long renewDelegationToken(String delegationToken) throws RangerRazException {
        String maskedDelegationToken = null;
        if (StringUtils.isNotBlank((String)delegationToken)) {
            maskedDelegationToken = MASKED_TOKEN_STR;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazClient.renewDelegationToken({})", (Object)maskedDelegationToken);
        }
        Long ret = -1L;
        if (!this.isKerberosAuthenticated()) {
            LOG.error("Kerberos Authentication is Required, to renew RAZ delegaton token.");
            throw MISSING_KERBEROS_RENEW_DT;
        }
        Map<String, String> queryParams = this.constructMap(PARAM_OP, OP_RENEWDELEGATIONTOKEN, PARAM_TOKEN, delegationToken, "AUTH_TYPE", "KERBEROS", "DT_OPERATION_TYPE", OP_RENEWDELEGATIONTOKEN);
        UserGroupInformation user = this.getUgi(queryParams);
        PrivilegedExceptionAction<String> action = this.getPrivilegedAction(RangerRESTClient.HTTP_METHOD.PUT, "", queryParams, DUMMY_POST_PARAM, String.class);
        String response = this.executeAction(action, user);
        JsonNode node = this.getJsonNode(response, "long");
        ret = node.asLong();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRazClient.renewDelegationToken({}): DT nextExpiry={}", (Object)maskedDelegationToken, (Object)ret);
        }
        return ret;
    }

    public Boolean cancelDelegationToken(String delegationToken) throws RangerRazException {
        String maskedDelegationToken = null;
        if (StringUtils.isNotBlank((String)delegationToken)) {
            maskedDelegationToken = MASKED_TOKEN_STR;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazClient.cancelDelegationToken({})", (Object)maskedDelegationToken);
        }
        Boolean ret = false;
        if (!this.isKerberosAuthenticated()) {
            LOG.error("Kerberos Authentication is Required, to cancel RAZ delegation token.");
            throw MISSING_KERBEROS_CANCEL_DT;
        }
        Map<String, String> queryParams = this.constructMap(PARAM_OP, OP_CANCELDELEGATIONTOKEN, PARAM_TOKEN, delegationToken, "AUTH_TYPE", "KERBEROS", "DT_OPERATION_TYPE", OP_CANCELDELEGATIONTOKEN);
        UserGroupInformation user = this.getUgi(queryParams);
        PrivilegedExceptionAction<String> action = this.getPrivilegedAction(RangerRESTClient.HTTP_METHOD.PUT, "", queryParams, DUMMY_POST_PARAM, String.class);
        this.executeAction(action, user);
        ret = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRazClient.cancelDelegationToken(): ret={}", (Object)ret);
        }
        return ret;
    }

    public RangerRazMultiOperationResult checkPrivileges(RangerRazMultiOperationRequest requests, String delegationToken) throws RangerRazException {
        String maskedDelegationToken = null;
        if (StringUtils.isNotBlank((String)delegationToken)) {
            maskedDelegationToken = MASKED_TOKEN_STR;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazClient.checkPrivileges({}, {})", (Object)requests, (Object)maskedDelegationToken);
        }
        RangerRazMultiOperationResult ret = null;
        String url = String.format(RAZ_API_MULTI_RESOURCE, requests.getServiceType());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        UserGroupInformation user = null;
        if (!StringUtils.isEmpty((String)delegationToken)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerRazClient.checkPrivileges(): RAZ Delegation token will be used to authenticate.");
            }
            queryParams.put(PARAM_DELEGATION, delegationToken);
            queryParams.put("AUTH_TYPE", "RAZ-DT");
        } else if (this.isKerberosAuthenticated()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerRazClient.checkPrivileges(): Since RAZ Delegation token is missing, Kerberos Authentication will be used to authenticate.");
            }
            user = this.getUgi(queryParams);
            queryParams.put("AUTH_TYPE", "KERBEROS");
        }
        PrivilegedExceptionAction<RangerRazMultiOperationResult> action = this.getPrivilegedAction(RangerRESTClient.HTTP_METHOD.POST, url, queryParams, requests, RangerRazMultiOperationResult.class);
        try {
            ret = this.executeAction(action, user);
        }
        catch (RangerRazException rre) {
            if (rre.getErrorCode() == RangerRazErrorCode.RAZ_CLIENT_UNAUTHORIZED_ACCESS) {
                this.printAvailableAuthDetails(delegationToken, queryParams);
            }
            throw rre;
        }
        if (ret != null && ret.getOperResults() != null && ret.getOperResults().size() > 0) {
            this.updateLatestRazIdMappingsVersion(ret.getOperResults().get(0));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRazClient.checkPrivileges(): ret={}", (Object)ret);
        }
        return ret;
    }

    public RangerRazResult checkPrivilege(RangerRazRequest request, String delegationToken) throws RangerRazException {
        String maskedDelegationToken = null;
        if (StringUtils.isNotBlank((String)delegationToken)) {
            maskedDelegationToken = MASKED_TOKEN_STR;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("==> RangerRazClient.checkPrivilege({}, {})", (Object)request, (Object)maskedDelegationToken);
        }
        RangerRazResult ret = null;
        String url = String.format(RAZ_API_SINGLE_RESOURCE, request.getServiceType());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        UserGroupInformation user = null;
        if (!StringUtils.isEmpty((String)delegationToken)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerRazClient.checkPrivilege(): RAZ Delegation token will be used to authenticate.");
            }
            queryParams.put(PARAM_DELEGATION, delegationToken);
            queryParams.put("AUTH_TYPE", "RAZ-DT");
        } else if (this.isKerberosAuthenticated()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerRazClient.checkPrivilege(): Since RAZ Delegation token is missing Kerberos TGT will be used to authenticate.");
            }
            user = this.getUgi(queryParams);
            queryParams.put("AUTH_TYPE", "KERBEROS");
        }
        PrivilegedExceptionAction<RangerRazResult> action = this.getPrivilegedAction(RangerRESTClient.HTTP_METHOD.POST, url, queryParams, request, RangerRazResult.class);
        try {
            ret = this.executeAction(action, user);
        }
        catch (RangerRazException rre) {
            if (rre.getErrorCode() == RangerRazErrorCode.RAZ_CLIENT_UNAUTHORIZED_ACCESS) {
                this.printAvailableAuthDetails(delegationToken, queryParams);
            }
            throw rre;
        }
        if (ret != null && ret.getOperResult() != null) {
            this.updateLatestRazIdMappingsVersion(ret.getOperResult());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("<== RangerRazClient.checkPrivilege(): ret={}", (Object)ret);
        }
        return ret;
    }

    private static String getDTServiceName(List<String> razUrls) {
        String ret = null;
        if (razUrls != null && razUrls.size() > 0) {
            for (String razUrl : razUrls) {
                try {
                    ret = SecurityUtil.buildDTServiceName((URI)URI.create(razUrl), (int)6181);
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        if (StringUtils.isEmpty(ret)) {
            ret = DEFAULT_DT_SERVICE_NAME;
        }
        return ret;
    }

    private <T> PrivilegedExceptionAction<T> getPrivilegedAction(RangerRESTClient.HTTP_METHOD method, String relativeUrl, Map<String, String> queryParams, Object postParam, Class<T> clazz) {
        return () -> this.restClient.executeHttpRequest(method, relativeUrl, queryParams, postParam, clazz);
    }

    private <T> T executeAction(PrivilegedExceptionAction<T> action, UserGroupInformation owner) throws RangerRazException {
        Object ret = null;
        try {
            ret = owner != null ? owner.doAs(action) : (Object)action.run();
        }
        catch (Exception excp) {
            if (excp.getCause() instanceof RangerRazException) {
                throw (RangerRazException)excp.getCause();
            }
            if (excp instanceof RangerRazException) {
                throw (RangerRazException)excp;
            }
            throw new RangerRazException(excp);
        }
        if (ret == null) {
            throw new RangerRazException(RangerRazErrorCode.RAZ_CLIENT_NULL_RESPONSE, new Object[0]);
        }
        return (T)ret;
    }

    private JsonNode getJsonNode(String jsonString, String value) throws RangerRazException {
        JsonNode ret = null;
        if (jsonString != null) {
            try {
                JsonNode node = this.mapper.readTree(jsonString);
                if (node != null) {
                    ret = node.findValue(value);
                }
            }
            catch (IOException excp) {
                RangerRazClientLogger.error(LOG, "RangerRazClient.getJsonNode({}): failed to parse the response", (Object)jsonString, (Object)excp);
                throw new RangerRazException(RangerRazErrorCode.RAZ_CLIENT_INVALID_RESPONSE, jsonString);
            }
        }
        if (ret == null) {
            RangerRazClientLogger.error(LOG, "RangerRazClient.getJsonNode({}): {} not found", (Object)jsonString, (Object)value);
            throw new RangerRazException(RangerRazErrorCode.RAZ_CLIENT_INVALID_RESPONSE, value + " not found");
        }
        return ret;
    }

    private UserGroupInformation getUgi(Map<String, String> queryParams) throws RangerRazException {
        UserGroupInformation ret = this.ugi;
        UserGroupInformation realUser = ret.getRealUser();
        if (realUser != null) {
            if (queryParams != null && !StringUtils.equals((String)realUser.getShortUserName(), (String)ret.getShortUserName())) {
                String proxyUser = ret.getShortUserName();
                queryParams.put(PARAM_DOAS, proxyUser);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RangerRazClient.getUgi(): owner = {} and proxy user = {}", (Object)realUser.getShortUserName(), (Object)proxyUser);
                }
            }
            ret = realUser;
        }
        return ret;
    }

    private boolean isKerberosAuthenticated() {
        boolean isKerberosAuthenticated = false;
        try {
            UserGroupInformation loggedInUser = UserGroupInformation.getLoginUser();
            boolean isSecurityEnabled = UserGroupInformation.isSecurityEnabled();
            boolean hasKerberosCredentials = loggedInUser.hasKerberosCredentials();
            UserGroupInformation.AuthenticationMethod loggedInUserAuthMethod = loggedInUser.getAuthenticationMethod();
            boolean bl = isKerberosAuthenticated = isSecurityEnabled && hasKerberosCredentials && loggedInUserAuthMethod.equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS);
            if (isKerberosAuthenticated) {
                loggedInUser.checkTGTAndReloginFromKeytab();
            }
        }
        catch (IOException e) {
            LOG.error("Failed to get authentication details. Exception : {}", (Throwable)e);
        }
        return isKerberosAuthenticated;
    }

    private Map<String, String> constructMap(String ... str) {
        HashMap<String, String> ret = new HashMap<String, String>();
        int effectiveLength = str.length;
        if (effectiveLength % 2 != 0) {
            LOG.warn("===>> RangerRazClient.constructMap(): skipping last argument [{}]", (Object)str[--effectiveLength]);
        }
        for (int i = 0; i < effectiveLength; i += 2) {
            ret.put(str[i], str[i + 1]);
        }
        return ret;
    }

    public RangerRazIdentityMappings getRangerRazIdentityMappings(String delegationToken) throws RangerRazException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazClient.getRangerRazIdentityMappings()");
        }
        RangerRazIdentityMappings ret = null;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        UserGroupInformation user = null;
        if (!StringUtils.isEmpty((String)delegationToken)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerRazClient.getRangerRazIdentityMappings(): RAZ Delegation token will be used to authenticate.");
            }
            queryParams.put(PARAM_DELEGATION, delegationToken);
        } else if (this.isKerberosAuthenticated()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerRazClient.getRangerRazIdentityMappings(): Since RAZ Delegation token is missing Kerberos TGT will be used to authenticate.");
            }
            user = this.getUgi(queryParams);
        }
        PrivilegedExceptionAction<RangerRazIdentityMappings> action = this.getPrivilegedAction(RangerRESTClient.HTTP_METHOD.GET, RAZ_API_DOWNLOAD_OID_MAP, queryParams, null, RangerRazIdentityMappings.class);
        ret = this.executeAction(action, user);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRazClient.getRangerRazIdentityMappings(): ret={}", (Object)ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RangerRazIdentityMappingsUtil getIdentityMappingUtil(String delegationToken) throws RangerRazException {
        RangerRazIdentityMappingsUtil ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazClient.getIdentityMappingUtil()");
        }
        if ((ret = this.razIdMappUtil) == null || !latestRazIdMappingVersion.equals(ret.getVersion())) {
            Object object = DUMMY_POST_PARAM;
            synchronized (object) {
                ret = this.razIdMappUtil;
                if (ret == null || !latestRazIdMappingVersion.equals(ret.getVersion())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("==> RangerRazClient.getIdentityMappingUtil(): updating cached razIdMappUtil");
                    }
                    RangerRazIdentityMappings razIdMappings = this.getRangerRazIdentityMappings(delegationToken);
                    latestRazIdMappingVersion = razIdMappings.getVersion();
                    ret = this.razIdMappUtil = new RangerRazIdentityMappingsUtil(razIdMappings);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRazClient.getIdentityMappingUtil(): ret={}", (Object)ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLatestRazIdMappingsVersion(RangerRazResultBase.ResourceAccessResult rangerAccessResult) {
        Long latestRazIdMappsVersion;
        String razMappingVersionStr;
        Map<String, String> map;
        if (rangerAccessResult != null && MapUtils.isNotEmpty(map = rangerAccessResult.getAdditionalInfo()) && StringUtils.isNotBlank((String)(razMappingVersionStr = map.get("RAZ_ID_MAP_VERSION"))) && !(latestRazIdMappsVersion = Long.valueOf(razMappingVersionStr)).equals(latestRazIdMappingVersion)) {
            Object object = DUMMY_POST_PARAM;
            synchronized (object) {
                if (!latestRazIdMappsVersion.equals(latestRazIdMappingVersion)) {
                    latestRazIdMappingVersion = Long.valueOf(razMappingVersionStr);
                }
            }
        }
    }

    private void printAvailableAuthDetails(String delegationToken, Map<String, String> queryParams) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("RAZ Delegation Token: IsAuthInfoPresent ? {}", (Object)StringUtils.isNotBlank((String)delegationToken));
            LOG.debug("Kerberos TGT        : IsAuthInfoPresent ? {}", (Object)this.isKerberosAuthenticated());
            LOG.debug("Auth Cred used by client: {}", (Object)queryParams.get("AUTH_TYPE"));
        }
    }

    public static String maskParam(String orgParam) {
        String ret = null;
        if (StringUtils.isNotBlank((String)orgParam)) {
            StringBuffer tempRazDToken = new StringBuffer();
            if (orgParam.length() > RAZ_CLIENT_SKIP_MASK_FOR_FIRST_DEFAULT) {
                tempRazDToken.append(orgParam.substring(0, RAZ_CLIENT_SKIP_MASK_FOR_FIRST_DEFAULT));
            }
            tempRazDToken.append(MASKED_TOKEN_STR);
            ret = tempRazDToken.toString();
        }
        return ret;
    }
}

