/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.intg.client;

import com.sun.jersey.api.client.ClientHandlerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.raz.intg.RangerRazErrorCode;
import org.apache.ranger.raz.intg.RangerRazException;
import org.apache.ranger.raz.intg.client.RangerCredentialProvider;
import org.apache.ranger.raz.intg.client.RangerRazClient;
import org.apache.ranger.raz.intg.client.RangerRazClientLogger;
import org.apache.ranger.raz.intg.client.executor.HttpClientExecutor;
import org.apache.ranger.raz.intg.client.executor.RestClientExecutorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerRESTClient {
    private static final Logger LOG = LoggerFactory.getLogger(RangerRESTClient.class);
    public static final String RANGER_PROP_REST_CLIENT_CLASS = "ranger.raz.client.executor.class";
    public static final String RANGER_DEFAULT_REST_CLIENT_CLASS = "org.apache.ranger.raz.intg.client.executor.RestClientExecutorApacheHttp";
    public static final String RANGER_PROP_REST_CLIENT_MAX_RETRY = "ranger.raz.client.max.retry";
    public static final String RANGER_PROP_JWT_SERVER_COOKIE_NAME = "ranger.raz.client.auth.jwt.server.cookie.name";
    public static final String RANGER_PROP_REST_CLIENT_REQ_PARAMS_TO_MASK = "ranger.raz.client.request.params.to.mask";
    public static final String RANGER_DEFAULT_REST_CLIENT_REQ_PARAMS_TO_MASK = "token,delegation";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE = "xasecure.policymgr.clientssl.keystore";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE = "xasecure.policymgr.clientssl.keystore.type";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL = "xasecure.policymgr.clientssl.keystore.credential.file";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL_ALIAS = "sslKeyStore";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE_DEFAULT = KeyStore.getDefaultType();
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE = "xasecure.policymgr.clientssl.truststore";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE = "xasecure.policymgr.clientssl.truststore.type";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL = "xasecure.policymgr.clientssl.truststore.credential.file";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL_ALIAS = "sslTrustStore";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE_DEFAULT = KeyStore.getDefaultType();
    private static final String HADOOP_SSL_CLIENT_CONF_FILE = "hadoop.ssl.client.conf";
    private static final String HADOOP_SSL_CLIENT_CONF_FILE_DEFAULT = "ssl-client.xml";
    private static final String HADOOP_SSL_CLIENT_TRUSTSTORE_LOC = "ssl.client.truststore.location";
    private static final String HADOOP_SSL_CLIENT_TRUSTSTORE_PWD = "ssl.client.truststore.password";
    private static final String HADOOP_SSL_CLIENT_TRUSTSTORE_TYPE = "ssl.client.truststore.type";
    public static final String RANGER_SSL_KEYMANAGER_ALGO_TYPE = KeyManagerFactory.getDefaultAlgorithm();
    public static final String RANGER_SSL_TRUSTMANAGER_ALGO_TYPE = TrustManagerFactory.getDefaultAlgorithm();
    public static final String RANGER_SSL_CONTEXT_ALGO_TYPE = "TLS";
    private String mUrl;
    private String mSslConfigFileName;
    private String mUsername;
    private String mPassword;
    private boolean mIsSSL;
    private String mKeyStoreURL;
    private String mKeyStoreAlias;
    private String mKeyStoreFile;
    private String mKeyStoreType;
    private String mTrustStoreURL;
    private String mTrustStoreAlias;
    private String mTrustStoreFile;
    private String mTrustStoreFilePwd;
    private String mTrustStoreType;
    private String clientClassName;
    private String jwtServerCookieName;
    private int mRestClientConnTimeOutMs;
    private int mRestClientReadTimeOutMs;
    private int lastKnownActiveUrlIndex;
    private int mMaxConnections;
    private int mMaxConnectionsPerHost;
    private int mMaxAttempts;
    private int validateAfterInactivityMs;
    private int poolRetryCount;
    private final List<String> configuredURLs;
    private final Set<String> listOfRequestParamsToMask = new HashSet<String>();
    private volatile HttpClientExecutor client;
    private final Configuration configuration;

    public RangerRESTClient(String url, String sslConfigFileName, Configuration config, boolean useLocalRazService) throws IOException {
        this.mUrl = url;
        this.mSslConfigFileName = sslConfigFileName;
        this.configuredURLs = this.getURLs(this.mUrl, useLocalRazService);
        this.mMaxAttempts = config.getInt(RANGER_PROP_REST_CLIENT_MAX_RETRY, 3);
        this.configuration = config;
        this.init(config);
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public int getRestClientConnTimeOutMs() {
        return this.mRestClientConnTimeOutMs;
    }

    public void setRestClientConnTimeOutMs(int mRestClientConnTimeOutMs) {
        this.mRestClientConnTimeOutMs = mRestClientConnTimeOutMs;
    }

    public int getRestClientReadTimeOutMs() {
        return this.mRestClientReadTimeOutMs;
    }

    public void setRestClientReadTimeOutMs(int mRestClientReadTimeOutMs) {
        this.mRestClientReadTimeOutMs = mRestClientReadTimeOutMs;
    }

    public void setBasicAuthInfo(String username, String password) {
        this.mUsername = username;
        this.mPassword = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClientExecutor getClient() {
        HttpClientExecutor result = this.client;
        if (result == null) {
            RangerRESTClient rangerRESTClient = this;
            synchronized (rangerRESTClient) {
                result = this.client;
                if (result == null) {
                    this.client = result = this.buildClient();
                }
            }
        }
        return result;
    }

    public void resetClient() {
        this.client = null;
    }

    public int getLastKnownActiveUrlIndex() {
        return this.lastKnownActiveUrlIndex;
    }

    public List<String> getConfiguredURLs() {
        return this.configuredURLs;
    }

    public boolean isSSL() {
        return this.mIsSSL;
    }

    public void setSSL(boolean mIsSSL) {
        this.mIsSSL = mIsSSL;
    }

    public int getmMaxConnections() {
        return this.mMaxConnections;
    }

    public void setmMaxConnections(int maxConnections) {
        this.mMaxConnections = maxConnections;
    }

    public int getMaxConnectionsPerHost() {
        return this.mMaxConnectionsPerHost;
    }

    public void setMaxConnectionsPerHost(int maxConnectionsPerHost) {
        this.mMaxConnectionsPerHost = maxConnectionsPerHost;
    }

    public <T> T executeHttpRequest(HTTP_METHOD method, String relativeUrl, Map<String, String> params, Object obj, Class<T> clazz) throws Exception {
        if (LOG.isTraceEnabled()) {
            HashMap<String, String> maskedParamSet = new HashMap<String, String>(params);
            for (String paramToMask : this.listOfRequestParamsToMask) {
                String paramOrgValue = (String)maskedParamSet.get(paramToMask);
                maskedParamSet.put(paramToMask, RangerRazClient.maskParam(paramOrgValue));
            }
            LOG.trace("==> RangerRESTClient.executeHttpRequest({}, {}, {}, {}, {})", new Object[]{method, relativeUrl, maskedParamSet, obj, clazz});
        }
        T finalResponse = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int noOfRazHost = this.configuredURLs.size();
        for (int urlIndex = 0; urlIndex < noOfRazHost; ++urlIndex) {
            for (int attempt = 0; attempt < this.mMaxAttempts; ++attempt) {
                boolean isLastAttempt = attempt == this.mMaxAttempts - 1 && urlIndex == noOfRazHost - 1;
                int currentIndex = (startIndex + urlIndex) % noOfRazHost;
                try {
                    switch (method) {
                        case GET: {
                            finalResponse = this.getClient().getAndParse(this.configuredURLs.get(currentIndex) + relativeUrl, params, clazz);
                            break;
                        }
                        case POST: {
                            finalResponse = this.getClient().postAndParse(this.configuredURLs.get(currentIndex) + relativeUrl, params, obj, clazz);
                            break;
                        }
                        case PUT: {
                            finalResponse = this.getClient().putAndParse(this.configuredURLs.get(currentIndex) + relativeUrl, params, obj, clazz);
                            break;
                        }
                        case DELETE: {
                            finalResponse = this.getClient().deleteAndParse(this.configuredURLs.get(currentIndex) + relativeUrl, params, clazz);
                            break;
                        }
                    }
                    if (finalResponse == null) continue;
                    this.setLastKnownActiveUrlIndex(currentIndex);
                    break;
                }
                catch (ClientHandlerException ex) {
                    RangerRazClientLogger.warn(LOG, "Failed to communicate with Raz, URL: {} {}", (Object)this.configuredURLs.get(currentIndex), (Object)"ClientHandlerException...trying again to connect");
                    this.processException(isLastAttempt, ex);
                    continue;
                }
                catch (RangerRazException ex) {
                    this.processRazException(isLastAttempt, ex, currentIndex);
                    continue;
                }
                catch (UnknownHostException ue) {
                    RangerRazClientLogger.warn(LOG, "Failed to communicate with Raz, URL: {} {}", (Object)this.configuredURLs.get(currentIndex), (Object)"UnknownHostException...trying next raz host");
                    this.processException(isLastAttempt, ue);
                    break;
                }
                catch (URISyntaxException urise) {
                    RangerRazClientLogger.warn(LOG, "Failed to communicate with Raz, URL: {} {}", (Object)this.configuredURLs.get(currentIndex), (Object)"URISyntaxException...trying next raz host");
                    this.processException(isLastAttempt, urise);
                    break;
                }
                catch (ConnectException ce) {
                    RangerRazClientLogger.warn(LOG, "Failed to communicate with Raz, URL: {} {}", (Object)this.configuredURLs.get(currentIndex), (Object)"ConnectException...trying next raz host");
                    this.processException(isLastAttempt, ce);
                    break;
                }
                catch (IOException ex) {
                    RangerRazClientLogger.warn(LOG, "Failed to communicate with Raz, URL: {} {}", (Object)this.configuredURLs.get(currentIndex), (Object)"Exception...trying next raz host");
                    this.processExceptionFinal(isLastAttempt, ex);
                    continue;
                }
                catch (Exception e) {
                    RangerRazClientLogger.warn(LOG, "Failed to communicate with Raz, URL: {} {}", (Object)this.configuredURLs.get(currentIndex), (Object)"Exception...trying next raz host");
                    this.processExceptionFinal(isLastAttempt, e);
                    break;
                }
            }
            if (finalResponse != null) break;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("<== RangerRESTClient.executeHttpRequest()");
        }
        return finalResponse;
    }

    protected SSLContext getSSLContext(KeyManager[] kmList, TrustManager[] tmList) {
        SSLContext ret = null;
        try {
            if (tmList == null) {
                tmList = this.setSSLContextFromHadoopConfFile();
            }
            SSLContext sslContext = SSLContext.getInstance(RANGER_SSL_CONTEXT_ALGO_TYPE);
            sslContext.init(kmList, tmList, new SecureRandom());
            ret = sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            RangerRazClientLogger.error(LOG, "SSL algorithm is not available in the environment", e);
            throw new IllegalStateException("SSL algorithm is not available in the environment: " + e.getMessage(), e);
        }
        catch (KeyManagementException e) {
            RangerRazClientLogger.error(LOG, "Unable to initials the SSLContext", e);
            throw new IllegalStateException("Unable to initials the SSLContex: " + e.getMessage(), e);
        }
        catch (IOException ioe) {
            RangerRazClientLogger.error(LOG, "Unable to fetch the SSLContext from default Hadoop SSL conf: {}", (Object)HADOOP_SSL_CLIENT_CONF_FILE, (Object)ioe);
            throw new IllegalStateException("Unable to fetch the SSLContext from default Hadoop SSL conf: " + ioe.getMessage(), ioe);
        }
        return ret;
    }

    protected void processException(boolean isLastAttempt, ClientHandlerException e) throws Exception {
        if (isLastAttempt) {
            LOG.error("Failed to communicate with all Raz URLs: [{}]", this.configuredURLs);
            LOG.error("Verify that, the URLs are correct and corresponding services are running & accessible.");
            throw e;
        }
    }

    protected void processException(boolean isLastAttempt, UnknownHostException e) throws Exception {
        if (isLastAttempt) {
            LOG.error("Failed to communicate with all Raz URLs: [{}]", this.configuredURLs);
            LOG.error("Verify that, the URLs are correct and corresponding services are running & accessible.");
            throw e;
        }
    }

    protected void processException(boolean isLastAttempt, URISyntaxException e) throws Exception {
        if (isLastAttempt) {
            LOG.error("Failed to communicate with all Raz URLs: [{}]", this.configuredURLs);
            LOG.error("Verify that, the URLs are correct and corresponding services are running & accessible.");
            throw e;
        }
    }

    protected void processException(boolean isLastAttempt, ConnectException e) throws Exception {
        if (isLastAttempt) {
            LOG.error("Failed to communicate with all Raz URLs: [{}]", this.configuredURLs);
            LOG.error("Verify that, the URLs are correct and corresponding services are running & accessible.");
            throw e;
        }
    }

    protected void processExceptionFinal(boolean isLastAttempt, Exception e) throws Exception {
        if (isLastAttempt) {
            LOG.error("Failed to communicate with all Raz URLs: [{}]", this.configuredURLs);
            LOG.error("Verify that, the URLs are correct and corresponding services are running & accessible.");
            throw e;
        }
    }

    protected void processRazException(boolean isLastAttempt, RangerRazException e, int currentIndex) throws Exception {
        if (e.getErrorCode().equals((Object)RangerRazErrorCode.RAZ_CLIENT_REQUEST_FAILED)) {
            RangerRazClientLogger.warn(LOG, "Failed to communicate with Raz, URL: {}", (Object)this.configuredURLs.get(currentIndex));
            if (isLastAttempt) {
                LOG.error("Failed to communicate with all Raz URLs: [{}]", this.configuredURLs);
                LOG.error("Verify that, the URLs are correct and corresponding services are running & accessible.");
                throw e;
            }
        } else {
            if (e.getErrorCode().equals((Object)RangerRazErrorCode.RAZ_CLIENT_ACCESS_DENIED)) {
                IOException ioe = new IOException("Permission denied", e);
                throw ioe;
            }
            throw e;
        }
    }

    protected void setLastKnownActiveUrlIndex(int lastKnownActiveUrlIndex) {
        this.lastKnownActiveUrlIndex = lastKnownActiveUrlIndex;
    }

    protected void setKeyStoreType(String mKeyStoreType) {
        this.mKeyStoreType = mKeyStoreType;
    }

    protected void setTrustStoreType(String mTrustStoreType) {
        this.mTrustStoreType = mTrustStoreType;
    }

    public int getValidateAfterInactivityMs() {
        return this.validateAfterInactivityMs;
    }

    public void setValidateAfterInactivityMs(int validateAfterInactivityMs) {
        this.validateAfterInactivityMs = validateAfterInactivityMs;
    }

    public int getPoolRetryCount() {
        return this.poolRetryCount;
    }

    public void setPoolRetryCount(int poolRetryCount) {
        this.poolRetryCount = poolRetryCount;
    }

    private HttpClientExecutor buildClient() {
        RestClientExecutorConfig config = new RestClientExecutorConfig();
        config.setUsername(this.mUsername);
        config.setPassword(this.mPassword);
        config.setRestClientConnTimeOutMs(this.mRestClientConnTimeOutMs);
        config.setRestClientReadTimeOutMs(this.mRestClientReadTimeOutMs);
        config.setMaxConnections(this.mMaxConnections);
        config.setMaxConnectionsPerHost(this.mMaxConnectionsPerHost);
        config.setSsl(this.mIsSSL);
        config.setValidateAfterInactivityMs(this.validateAfterInactivityMs);
        config.setPoolRetryCount(this.poolRetryCount);
        if (this.mIsSSL) {
            KeyManager[] kmList = this.getKeyManagers();
            TrustManager[] tmList = this.getTrustManagers();
            SSLContext sslContext = this.getSSLContext(kmList, tmList);
            config.setSslContext(sslContext);
        }
        config.setJwtServerCookieName(this.jwtServerCookieName);
        HttpClientExecutor clientExecutor = null;
        try {
            Class<?> cls = Class.forName(this.clientClassName);
            clientExecutor = (HttpClientExecutor)cls.getDeclaredConstructor(RestClientExecutorConfig.class, Configuration.class).newInstance(config, this.configuration);
        }
        catch (Exception e) {
            LOG.error("Exception occured while creating instance of executor class[{}]. Exception={}", (Object)this.clientClassName, (Object)e);
        }
        return clientExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Configuration config) {
        this.mIsSSL = this.isSsl(this.mUrl);
        if (this.mIsSSL) {
            InputStream in = null;
            InputStream inHadoopSsl = null;
            String hadoopSslConfFile = config.get(HADOOP_SSL_CLIENT_CONF_FILE, HADOOP_SSL_CLIENT_CONF_FILE_DEFAULT);
            try {
                in = this.getFileInputStream(this.mSslConfigFileName);
                if (in != null) {
                    config.addResource(in);
                }
                this.mKeyStoreURL = config.get(RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL);
                this.mKeyStoreAlias = RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL_ALIAS;
                this.mKeyStoreType = config.get(RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE);
                this.mKeyStoreFile = config.get(RANGER_POLICYMGR_CLIENT_KEY_FILE);
                this.mTrustStoreURL = config.get(RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL);
                this.mTrustStoreAlias = RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL_ALIAS;
                this.mTrustStoreType = config.get(RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE);
                this.mTrustStoreFile = config.get(RANGER_POLICYMGR_TRUSTSTORE_FILE);
                if (StringUtils.isNotEmpty((String)hadoopSslConfFile)) {
                    inHadoopSsl = this.getFileInputStream(hadoopSslConfFile);
                    Configuration hadoopSslConfiguration = new Configuration();
                    if (inHadoopSsl != null) {
                        hadoopSslConfiguration.addResource(inHadoopSsl);
                    }
                    if (StringUtils.isEmpty((String)this.mTrustStoreFile)) {
                        this.mTrustStoreFile = hadoopSslConfiguration.get(HADOOP_SSL_CLIENT_TRUSTSTORE_LOC);
                    }
                    this.mTrustStoreFilePwd = hadoopSslConfiguration.get(HADOOP_SSL_CLIENT_TRUSTSTORE_PWD);
                    if (Objects.isNull(this.mTrustStoreType)) {
                        this.mTrustStoreType = hadoopSslConfiguration.get(HADOOP_SSL_CLIENT_TRUSTSTORE_TYPE);
                    }
                }
                this.close(in, this.mSslConfigFileName);
                this.close(inHadoopSsl, hadoopSslConfFile);
            }
            catch (IOException ioe) {
                RangerRazClientLogger.error(LOG, "Unable to load SSL Config FileName: [{}]", (Object)this.mSslConfigFileName, (Object)ioe);
            }
            finally {
                this.close(in, this.mSslConfigFileName);
                this.close(inHadoopSsl, hadoopSslConfFile);
            }
        }
        if (Objects.isNull(this.mKeyStoreType)) {
            this.mKeyStoreType = RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE_DEFAULT;
            LOG.info("===>> RangerRESTClient.init() : Since mKeyStoreType is NULL, setting System default. [mKeyStoreType={}]", (Object)this.mKeyStoreType);
        }
        if (Objects.isNull(this.mTrustStoreType)) {
            this.mTrustStoreType = RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE_DEFAULT;
            LOG.info("===>> RangerRESTClient.init() : Since mTrustStoreType is NULL, setting System default. [mTrustStoreType={}]", (Object)this.mTrustStoreType);
        }
        this.clientClassName = config.get(RANGER_PROP_REST_CLIENT_CLASS, RANGER_DEFAULT_REST_CLIENT_CLASS);
        String requestParamsToMask = config.get(RANGER_PROP_REST_CLIENT_REQ_PARAMS_TO_MASK, RANGER_DEFAULT_REST_CLIENT_REQ_PARAMS_TO_MASK);
        for (String requestParamToMask : requestParamsToMask.split(",")) {
            this.listOfRequestParamsToMask.add(requestParamToMask);
        }
        this.jwtServerCookieName = config.get(RANGER_PROP_JWT_SERVER_COOKIE_NAME);
    }

    private boolean isSsl(String url) {
        return !StringUtils.isEmpty((String)url) && url.toLowerCase().startsWith("https");
    }

    private KeyManager[] getKeyManagers() {
        KeyManager[] kmList = null;
        String keyStoreFilepwd = this.getCredential(this.mKeyStoreURL, this.mKeyStoreAlias);
        kmList = this.getKeyManagers(this.mKeyStoreFile, keyStoreFilepwd);
        return kmList;
    }

    private KeyManager[] getKeyManagers(String keyStoreFile, String keyStoreFilePwd) {
        KeyManager[] kmList;
        block12: {
            kmList = null;
            if (StringUtils.isNotEmpty((String)keyStoreFile) && StringUtils.isNotEmpty((String)keyStoreFilePwd)) {
                InputStream in = null;
                try {
                    in = this.getFileInputStream(keyStoreFile);
                    if (in != null) {
                        KeyStore keyStore = KeyStore.getInstance(this.mKeyStoreType);
                        keyStore.load(in, keyStoreFilePwd.toCharArray());
                        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(RANGER_SSL_KEYMANAGER_ALGO_TYPE);
                        keyManagerFactory.init(keyStore, keyStoreFilePwd.toCharArray());
                        kmList = keyManagerFactory.getKeyManagers();
                        break block12;
                    }
                    RangerRazClientLogger.error(LOG, "Unable to obtain keystore from file [{}]", (Object)keyStoreFile);
                    throw new IllegalStateException("Unable to find keystore file :" + keyStoreFile);
                }
                catch (KeyStoreException e) {
                    RangerRazClientLogger.error(LOG, "Unable to obtain from KeyStore: {}", (Object)e.getMessage(), (Object)e);
                    throw new IllegalStateException("Unable to init keystore:" + e.getMessage(), e);
                }
                catch (NoSuchAlgorithmException e) {
                    RangerRazClientLogger.error(LOG, "SSL algorithm is NOT available in the environment", e);
                    throw new IllegalStateException("SSL algorithm is NOT available in the environment :" + e.getMessage(), e);
                }
                catch (CertificateException e) {
                    RangerRazClientLogger.error(LOG, "Unable to obtain the requested certification ", e);
                    throw new IllegalStateException("Unable to obtain the requested certification :" + e.getMessage(), e);
                }
                catch (FileNotFoundException e) {
                    RangerRazClientLogger.error(LOG, "Unable to find the necessary SSL Keystore Files", e);
                    throw new IllegalStateException("Unable to find keystore file :" + keyStoreFile + ", error :" + e.getMessage(), e);
                }
                catch (IOException e) {
                    RangerRazClientLogger.error(LOG, "Unable to read the necessary SSL Keystore Files", e);
                    throw new IllegalStateException("Unable to read keystore file :" + keyStoreFile + ", error :" + e.getMessage(), e);
                }
                catch (UnrecoverableKeyException e) {
                    RangerRazClientLogger.error(LOG, "Unable to recover the key from keystore", e);
                    throw new IllegalStateException("Unable to recover the key from keystore :" + keyStoreFile + ", error :" + e.getMessage(), e);
                }
                finally {
                    this.close(in, keyStoreFile);
                }
            }
        }
        return kmList;
    }

    private TrustManager[] getTrustManagers() {
        TrustManager[] tmList = null;
        String trustStoreFilepwd = this.getCredential(this.mTrustStoreURL, this.mTrustStoreAlias);
        if (StringUtils.isEmpty((String)trustStoreFilepwd)) {
            trustStoreFilepwd = this.mTrustStoreFilePwd;
        }
        tmList = this.getTrustManagers(this.mTrustStoreFile, trustStoreFilepwd);
        return tmList;
    }

    private TrustManager[] getTrustManagers(String trustStoreFile, String trustStoreFilepwd) {
        TrustManager[] tmList;
        block11: {
            tmList = null;
            if (StringUtils.isNotEmpty((String)trustStoreFile) && StringUtils.isNotEmpty((String)trustStoreFilepwd)) {
                InputStream in = null;
                try {
                    in = this.getFileInputStream(trustStoreFile);
                    if (in != null) {
                        KeyStore trustStore = KeyStore.getInstance(this.mTrustStoreType);
                        trustStore.load(in, trustStoreFilepwd.toCharArray());
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(RANGER_SSL_TRUSTMANAGER_ALGO_TYPE);
                        trustManagerFactory.init(trustStore);
                        tmList = trustManagerFactory.getTrustManagers();
                        break block11;
                    }
                    RangerRazClientLogger.error(LOG, "Unable to obtain truststore from file [{}]", (Object)trustStoreFile);
                    throw new IllegalStateException("Unable to find truststore file :" + trustStoreFile);
                }
                catch (KeyStoreException e) {
                    RangerRazClientLogger.error(LOG, "Unable to obtain from KeyStore", e);
                    throw new IllegalStateException("Unable to init keystore:" + e.getMessage(), e);
                }
                catch (NoSuchAlgorithmException e) {
                    RangerRazClientLogger.error(LOG, "SSL algorithm is NOT available in the environment: {}", (Object)e.getMessage(), (Object)e);
                    throw new IllegalStateException("SSL algorithm is NOT available in the environment :" + e.getMessage(), e);
                }
                catch (CertificateException e) {
                    RangerRazClientLogger.error(LOG, "Unable to obtain the requested certification: {}", (Object)e.getMessage(), (Object)e);
                    throw new IllegalStateException("Unable to obtain the requested certification :" + e.getMessage(), e);
                }
                catch (FileNotFoundException e) {
                    RangerRazClientLogger.error(LOG, "Unable to find the necessary SSL TrustStore File: {}", (Object)trustStoreFile, (Object)e);
                    throw new IllegalStateException("Unable to find trust store file :" + trustStoreFile + ", error :" + e.getMessage(), e);
                }
                catch (IOException e) {
                    RangerRazClientLogger.error(LOG, "Unable to read the necessary SSL TrustStore Files: {}", (Object)trustStoreFile, (Object)e);
                    throw new IllegalStateException("Unable to read the trust store file :" + trustStoreFile + ", error :" + e.getMessage(), e);
                }
                finally {
                    this.close(in, trustStoreFile);
                }
            }
        }
        return tmList;
    }

    private TrustManager[] setSSLContextFromHadoopConfFile() throws IOException {
        TrustManager[] ret = null;
        Configuration config = new Configuration();
        String hadoopSslConfFile = config.get(HADOOP_SSL_CLIENT_CONF_FILE, HADOOP_SSL_CLIENT_CONF_FILE_DEFAULT);
        URL fUrl = this.getFileLocation(hadoopSslConfFile, config);
        if (fUrl != null) {
            RangerRazClientLogger.info(LOG, "addResourceIfReadable({}): resource file is {}", (Object)hadoopSslConfFile, (Object)fUrl);
            config.addResource(fUrl);
            this.mTrustStoreFile = config.get(HADOOP_SSL_CLIENT_TRUSTSTORE_LOC);
            this.mTrustStoreFilePwd = config.get(HADOOP_SSL_CLIENT_TRUSTSTORE_PWD);
            this.mTrustStoreType = config.get(HADOOP_SSL_CLIENT_TRUSTSTORE_TYPE);
            ret = this.getTrustManagers(this.mTrustStoreFile, this.mTrustStoreFilePwd);
        } else {
            RangerRazClientLogger.error(LOG, "addResourceIfReadable({}): couldn't find resource file location", (Object)hadoopSslConfFile);
        }
        return ret;
    }

    private URL getFileLocation(String fileName, Configuration config) {
        URL lurl = config.getClassLoader().getResource(fileName);
        if (lurl == null) {
            lurl = config.getClassLoader().getResource("/" + fileName);
        }
        return lurl;
    }

    private String getCredential(String url, String alias) {
        return RangerCredentialProvider.getInstance().getCredentialString(url, alias);
    }

    private InputStream getFileInputStream(String fileName) throws IOException {
        InputStream in = null;
        if (StringUtils.isNotEmpty((String)fileName)) {
            File f = new File(fileName);
            in = f.exists() ? new FileInputStream(f) : ClassLoader.getSystemResourceAsStream(fileName);
        }
        return in;
    }

    private void close(InputStream str, String filename) {
        if (str != null) {
            try {
                str.close();
            }
            catch (IOException excp) {
                RangerRazClientLogger.error(LOG, "Error while closing file: [{}]", (Object)filename, (Object)excp);
            }
        }
    }

    private List<String> getURLs(String configURLs, boolean useLocalRazService) throws UnknownHostException {
        List<String> configuredURLs = Collections.emptyList();
        if (configURLs != null) {
            String[] urls = configURLs.trim().split(",");
            configuredURLs = new ArrayList<String>(urls.length + 2);
            for (String strUrl : urls) {
                if (!StringUtils.isNotBlank((String)(strUrl = RangerRESTClient.cleanRestUrl(strUrl)))) continue;
                configuredURLs.add(strUrl);
            }
            if (useLocalRazService && !configuredURLs.isEmpty()) {
                String[] urlParts = configuredURLs.get(0).split(":");
                configuredURLs.add(0, RangerRESTClient.cleanRestUrl(urlParts[0] + "://" + InetAddress.getLocalHost().getHostName() + ":" + urlParts[2]));
                this.setLastKnownActiveUrlIndex(0);
            } else {
                this.setLastKnownActiveUrlIndex(new Random().nextInt(configuredURLs.size()));
            }
        }
        return configuredURLs;
    }

    private static String cleanRestUrl(String restUrl) {
        String ret = restUrl;
        if (!StringUtils.isEmpty((String)StringUtils.trimToEmpty((String)ret)) && (ret = ret.trim()).endsWith("/")) {
            ret = ret.substring(0, ret.length() - 1).trim();
        }
        return ret;
    }

    public static enum HTTP_METHOD {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

