/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.intg;

import com.sun.jersey.core.spi.factory.ResponseBuilderImpl;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.ranger.raz.intg.RangerRazErrorCode;

public class RangerRazException
extends Exception {
    private RangerRazErrorCode errorCode;
    private Map<String, String> rangerRazExceptionHeadersMap = new HashMap<String, String>();
    public static final String WEBAPPLICATIONEXCP_TAG = "webApplicationExcp";
    public static final String WEBAPPLICATIONEXCP_WITH_HEADERS_TAG = "webApplicationExcp_with_headers";

    public RangerRazException() {
        this(RangerRazErrorCode.INTERNAL_ERROR, new Object[0]);
    }

    public RangerRazException(String message) {
        super(message);
        this.errorCode = RangerRazErrorCode.INTERNAL_ERROR;
    }

    public RangerRazException(String message, Throwable cause) {
        super(message, cause);
        this.errorCode = RangerRazErrorCode.INTERNAL_ERROR;
    }

    public RangerRazException(Throwable cause) {
        super(cause);
        this.errorCode = RangerRazErrorCode.INTERNAL_ERROR;
    }

    public RangerRazException(RangerRazErrorCode errorCode, Object ... params) {
        super(errorCode.getFormattedErrorMessage(params));
        this.errorCode = errorCode;
    }

    public RangerRazException(RangerRazErrorCode errorCode, Throwable cause, Object ... params) {
        super(errorCode.getFormattedErrorMessage(params), cause);
        this.errorCode = errorCode;
    }

    public RangerRazException(Throwable cause, Map<String, String> rangerRazExceptionHeadersMap) {
        super(cause);
        this.errorCode = RangerRazErrorCode.INTERNAL_ERROR;
        this.rangerRazExceptionHeadersMap = rangerRazExceptionHeadersMap;
    }

    public WebApplicationException toWebApplicationException() {
        Response response = Response.status((Response.Status)this.errorCode.getHttpCode()).entity((Object)this.getMessage()).tag(WEBAPPLICATIONEXCP_TAG).type(MediaType.APPLICATION_JSON_TYPE).build();
        return new WebApplicationException(response);
    }

    public WebApplicationException toWebApplicationExceptionWithHeaders() {
        ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
        responseBuilder.status(this.errorCode.getHttpCode()).entity((Object)this.getMessage()).tag(WEBAPPLICATIONEXCP_WITH_HEADERS_TAG).type(MediaType.APPLICATION_JSON_TYPE);
        if (this.rangerRazExceptionHeadersMap != null) {
            for (Map.Entry<String, String> entry : this.rangerRazExceptionHeadersMap.entrySet()) {
                responseBuilder.header(entry.getKey(), (Object)entry.getValue());
            }
        }
        Response response = responseBuilder.build();
        return new WebApplicationException(response);
    }

    public RangerRazErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(RangerRazErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public Map<String, String> getRangerRazExceptionHeadersMap() {
        return this.rangerRazExceptionHeadersMap;
    }

    public void setRangerRazExceptionHeadersMap(Map<String, String> rangerRazExceptionHeadersMap) {
        this.rangerRazExceptionHeadersMap = rangerRazExceptionHeadersMap;
    }
}

