/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.intg;

import java.text.MessageFormat;
import java.util.Arrays;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RangerRazErrorCode {
    INVALID_PARAMETERS(400, "RANGER-400-00-001", "invalid parameters: {0}"),
    NOT_FOUND_SERVICE_TYPE(404, "RANGER-404-00-001", "{0}: service-type not found"),
    NOT_FOUND_SERVICE(404, "RANGER-404-00-002", "{0}: service not found"),
    NOT_FOUND_POLICY(404, "RANGER-404-00-003", "{0}: policy not found"),
    NOT_FOUND_SERVICE_TYPE_ID(404, "RANGER-404-00-004", "{0}: not a valid service-type id"),
    NOT_FOUND_SERVICE_ID(404, "RANGER-404-00-005", "{0}: not a valid service id"),
    NOT_FOUND_POLICY_ID(404, "RANGER-404-00-006", "{0}: not a valid policyid"),
    NOT_FOUND_RESOURCE_NAME(404, "RANGER-404-00-007", "{0}: resource-name not found"),
    NOT_FOUND_ACCESS_TYPE(404, "RANGER-404-00-008", "{0}: access-type not found"),
    NOT_FOUND_CONDITION_NAME(404, "RANGER-404-00-009", "{0}: condition-name not found"),
    NOT_FOUND_POLICY_TYPE(404, "RANGER-404-00-00a", "{0}: policy-type not found"),
    NOT_FOUND_MASK_TYPE(404, "RANGER-404-00-00b", "{0}: mask-type not found"),
    INTERNAL_ERROR(500, "RANGER-500-00-001", "Internal error {0}"),
    RAZ_CLIENT_NULL_RESPONSE(400, "RANGER-400-01-001", "null response"),
    RAZ_CLIENT_INVALID_RESPONSE(400, "RANGER-400-01-002", "invalid response: {0}"),
    RAZ_CLIENT_REQUEST_FAILED(400, "RANGER-400-01-003", "request failed: status={0}"),
    RAZ_CLIENT_NO_USER_PRESENT(401, "RANGER-401-01-001", "failed to get current user identity"),
    RAZ_CLIENT_UNAUTHORIZED_ACCESS(401, "RANGER-401-01-002", "Insufficient or missing authentication information: {0}"),
    RAZ_CLIENT_ACCESS_DENIED(403, "RANGER-403-01-001", "not authorized"),
    RAZ_ADLS_UNAUTHORIZED_ACCESS(403, "RANGER-403-02-001", "not authorized to perform {0} on path {1}"),
    RAZ_ADLS_INVALID_SAS_REST_API_VERSION(400, "RANGER-400-02-001", "invalid SAS version: {0}"),
    RAZ_ADLS_INVALID_SAS_DELEGATION_REQUEST_BOTH_OID_SET(400, "RANGER-400-02-002", "Delegation attempt with both authorized and unauthorized user OID made. Authorized UserOID: {0} Unauthorized UserOID: {1}. Action: {2} Path: {3}"),
    RAZ_ADLS_INVALID_AUTHZ_ACTION(400, "RANGER-400-02-003", "Unknown Authorizer action {0}");

    private static final Logger LOG;
    private final String errorCode;
    private final String errorMessage;
    private final Response.Status httpCode;
    private MessageFormat messageFormat = null;

    private RangerRazErrorCode(int httpCode, String errorCode, String errorMessage) {
        this.httpCode = Response.Status.fromStatusCode((int)httpCode);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public String getFormattedErrorMessage(Object ... params) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("==> RangerRazErrorCode.getFormattedErrorMessage({})", (Object)Arrays.toString(params));
            LOG.trace("==> httpCode={}", (Object)this.httpCode);
            LOG.trace("==> errorCode={}", (Object)this.errorCode);
            LOG.trace("==> errorMessage={}", (Object)this.errorMessage);
        }
        MessageFormat mf = this.messageFormat;
        String result = "";
        try {
            if (mf == null) {
                mf = this.messageFormat = new MessageFormat(this.errorMessage);
            }
            result = mf.format(params);
        }
        catch (Exception e) {
            LOG.error("Error : " + e);
            e.printStackTrace();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRazErrorCode.getFormattedErrorMessage({}): {}", (Object)Arrays.toString(params), (Object)result);
        }
        return result;
    }

    public Response.Status getHttpCode() {
        return this.httpCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    static {
        LOG = LoggerFactory.getLogger(RangerRazErrorCode.class);
    }
}

