/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.hook.s3.utils;

import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TokenUtils.class);

    public static <T extends DelegationTokenIdentifier> Token<T> lookupToken(Credentials credentials, Text service, Text expectedKind) throws IOException {
        if (expectedKind == null) {
            throw new IllegalArgumentException("expectedKind is null");
        }
        LOG.debug("Looking for token for service {} in credentials", (Object)service);
        Token token = credentials.getToken(service);
        if (token != null) {
            Text actualKind = token.getKind();
            LOG.debug("Found token of kind {}", (Object)actualKind);
            if (expectedKind.equals((Object)actualKind)) {
                return token;
            }
            throw new IOException("Token mismatch: expected token for " + service + " of type " + expectedKind + " but got a token of type " + actualKind);
        }
        LOG.debug("No token for {} found", (Object)service);
        return null;
    }
}

