/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.hook.s3.utils;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Utils {
    private static final Logger LOG = LoggerFactory.getLogger(S3Utils.class);
    private static final int BUCKET_REGION_CACHE_SIZE = 300;
    private static final Map<String, String> bucketRegionCache = Collections.synchronizedMap(new LinkedHashMap<String, String>(300, 1.1f, true){
        private static final long serialVersionUID = 23453L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 300;
        }
    });

    public static String lookupRegion(String bucketName, AWSCredentialsProvider credentialsProvider) throws SdkClientException, AmazonServiceException {
        String region = bucketRegionCache.get(bucketName);
        if (region != null) {
            return region;
        }
        AmazonS3 s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(credentialsProvider)).withForceGlobalBucketAccessEnabled(Boolean.valueOf(true))).withRegion("us-east-1")).build();
        String regionName = s3.getBucketLocation(bucketName);
        if (regionName.equals("US")) {
            regionName = "us-east-1";
        }
        bucketRegionCache.put(bucketName, regionName);
        LOG.info("Region for bucket {}={}", (Object)bucketName, (Object)regionName);
        return regionName;
    }

    public static String getBucketNameFromHost(String host) {
        String[] parts = host.split("\\.");
        if (parts.length > 0) {
            return parts[0];
        }
        return null;
    }

    public static String lookupRegionFromCache(String bucketName) {
        Preconditions.checkNotNull((Object)bucketName, (Object)"BucketName must be provided");
        return bucketRegionCache.get(bucketName);
    }

    public static void updateBucketToRegionCache(String bucketName, String regionName) {
        Preconditions.checkNotNull((Object)bucketName, (Object)"BucketName must be specified");
        Preconditions.checkNotNull((Object)regionName, (Object)"RegionName must be specified");
        bucketRegionCache.put(bucketName, regionName);
    }
}

