/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.hook.s3.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.raz.hook.s3.cache.SignerCache;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsRequestCacheKey;

public class SignerCacheImpl
implements SignerCache<AwsRequestCacheKey, Map<String, String>> {
    private final Cache<AwsRequestCacheKey, Map<String, String>> signerCache;
    public static final long CACHE_MAX_SIZE_DEFAULT = 100L;
    public static final long CACHE_KEY_EXPIRY_IN_SECONDS_DEFAULT = 30L;

    public SignerCacheImpl() {
        this(100L, 30L);
    }

    public SignerCacheImpl(long maxSize, long expiry) {
        this.signerCache = CacheBuilder.newBuilder().maximumSize(maxSize).expireAfterWrite(expiry, TimeUnit.SECONDS).build();
    }

    @Override
    public void put(AwsRequestCacheKey key, Map<String, String> value) {
        this.signerCache.put((Object)key, value);
    }

    @Override
    public Map<String, String> get(AwsRequestCacheKey key) {
        return (Map)this.signerCache.getIfPresent((Object)key);
    }

    @Override
    public long size() {
        return this.signerCache.size();
    }
}

