/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.hook.s3;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RazToken
implements Writable,
Serializable {
    private static final long serialVersionUID = 7508655772386801692L;
    public static final int MAX_TEXT_LENGTH = 32768;
    public static final int RAZTOKEN_EXPIRATION_OFFSET_SECONDS = 120;
    private static final Logger LOG = LoggerFactory.getLogger(RazToken.class);
    long issueTime;
    long expiryTime;
    String accessToken;

    public RazToken() {
    }

    public RazToken(long issueTime, long expiryTime, String accessToken) {
        this.issueTime = issueTime;
        this.expiryTime = expiryTime;
        this.accessToken = accessToken;
    }

    public long getIssueTime() {
        return this.issueTime;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.issueTime);
        out.writeLong(this.expiryTime);
        Text.writeString((DataOutput)out, (String)this.accessToken);
    }

    public void readFields(DataInput in) throws IOException {
        this.issueTime = in.readLong();
        this.expiryTime = in.readLong();
        this.accessToken = Text.readString((DataInput)in, (int)32768);
    }

    public boolean isAboutToExpire() {
        return this.isAboutToExpire(this.expiryTime, 120L, ChronoUnit.SECONDS);
    }

    public boolean isAboutToExpire(long expiryTime, long offset, TemporalUnit unit) {
        Instant now = Instant.now();
        LOG.debug("Raz token expiration:\n\tExpires in:\t{} seconds\n\tOffset:\t{} seconds\n\tTime left:\t{} seconds", new Object[]{expiryTime - now.getEpochSecond(), Duration.of(offset, unit).getSeconds(), expiryTime - now.plus(offset, unit).getEpochSecond()});
        return !Instant.ofEpochSecond(expiryTime).isAfter(now.plus(offset, unit));
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("RazToken{").append("issueTime=").append(this.issueTime).append(", expiryTime=").append(this.expiryTime);
        str.append("}");
        return str.toString();
    }
}

