/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.hook.s3;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.CredentialInitializationException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.raz.hook.s3.RazAnonymousAWSCredentialsProvider;
import org.apache.ranger.raz.hook.s3.RazDelegationTokenBinding;
import org.apache.ranger.raz.hook.s3.RazS3ClientCredentialsException;
import org.apache.ranger.raz.hook.s3.cache.BucketRegionCache;
import org.apache.ranger.raz.hook.s3.cache.SignerCache;
import org.apache.ranger.raz.hook.s3.utils.S3Utils;
import org.apache.ranger.raz.intg.RangerRazErrorCode;
import org.apache.ranger.raz.intg.RangerRazException;
import org.apache.ranger.raz.intg.client.RangerRazClient;
import org.apache.ranger.raz.model.RangerRazRequest;
import org.apache.ranger.raz.model.RangerRazRequestBase;
import org.apache.ranger.raz.model.RangerRazResult;
import org.apache.ranger.raz.model.RangerRazResultBase;
import org.apache.ranger.raz.s3.lib.HttpMethod;
import org.apache.ranger.raz.s3.lib.authorizer.CloudHttpRequest;
import org.apache.ranger.raz.s3.lib.authorizer.impl.S3CloudHttpRequest;
import org.apache.ranger.raz.s3.lib.aws.exceptions.RCSAWSException;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsRequest;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsRequestCacheKey;
import org.apache.ranger.raz.s3.lib.awsv2.AwsRequestParserV2;
import org.apache.ranger.raz.s3.lib.signer.SignRequest;
import org.apache.ranger.raz.s3.lib.signer.SignResponse;
import org.apache.ranger.raz.s3.lib.signer.impl.SignRequestImpl;
import org.apache.ranger.raz.s3.lib.signer.util.ProtoConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.checksums.DefaultChecksumAlgorithm;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.internal.signer.Checksummer;
import software.amazon.awssdk.http.auth.spi.signer.AsyncSignRequest;
import software.amazon.awssdk.http.auth.spi.signer.AsyncSignedRequest;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.services.m2.model.AccessDeniedException;

public class RazS3SignerPlugin
implements HttpSigner<AwsCredentialsIdentity> {
    private static final Logger LOG = LoggerFactory.getLogger(RazS3SignerPlugin.class);
    private static final String HOST = "Host";
    private static final String X_AMZ_DATE = "X-Amz-Date";
    static final String X_AMZ_SDK_CHECKSUM_ALGORITHM = "x-amz-sdk-checksum-algorithm";
    public static final String S3_EXPRESS_BUCKET_SUFFIX = "--x-s3";
    public static final String SESSION_PARAMETER = "session";
    private static final Set<String> listOfSignerHeadersToLogWhenReplaced = new HashSet<String>(Arrays.asList("Host", "X-Amz-Date", "x-amz-content-sha256", "Authorization"));
    static final String DEFAULT_SERVICE_TYPE = "s3";
    static final String DEFAULT_SERVICE_NAME = "cm_s3";
    static final String SERVICE_TYPE_CONFIG_KEY = "s3a.service.type";
    static final String SERVICE_NAME_CONFIG_KEY = "s3a.service.name";
    static final String CLUSTER_NAME_CONFIG_KEY = ".access.cluster.name";
    static final String PREFIX_TO_TRUNCATE = "op_";
    static final String REFERER_HEADER = "Referer";
    static final String OP_NAME_KEY = "op";

    public RazS3SignerPlugin() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== Raz S3 Signer client constructor");
        }
    }

    public SdkHttpFullRequest addCheckSumToRequest(SdkHttpFullRequest request) {
        SdkHttpFullRequest.Builder requestBuilder = request.toBuilder();
        if (request.firstMatchingHeader(X_AMZ_SDK_CHECKSUM_ALGORITHM).isPresent()) {
            LOG.debug("Checksum algorithm found as CRC32");
            Checksummer chechSummer = Checksummer.forFlexibleChecksum((String)"UNSIGNED_PAYLOAD", (ChecksumAlgorithm)DefaultChecksumAlgorithm.CRC32);
            chechSummer.checksum((ContentStreamProvider)request.contentStreamProvider().get(), (SdkHttpRequest.Builder)requestBuilder);
        }
        return requestBuilder.build();
    }

    public boolean checkIfS3ExpressBucket(String bucketName) {
        return bucketName.endsWith(S3_EXPRESS_BUCKET_SUFFIX);
    }

    public CompletableFuture<AsyncSignedRequest> signAsync(AsyncSignRequest<? extends AwsCredentialsIdentity> request) {
        LOG.trace("Signing async request:{}", (Object)request.request());
        throw new UnsupportedOperationException("Async signing not supported via RAZ");
    }

    public SignedRequest sign(software.amazon.awssdk.http.auth.spi.signer.SignRequest<? extends AwsCredentialsIdentity> toSignRequest) {
        SdkHttpFullRequest request;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> Sign request: {}", (Object)toSignRequest.request());
        }
        if ((request = (SdkHttpFullRequest)toSignRequest.request()).rawQueryParameters().containsKey(SESSION_PARAMETER)) {
            LOG.warn("s3a client must disable session creation by setting fs.s3a.s3express.create.session to false");
            return (SignedRequest)((SignedRequest.Builder)((SignedRequest.Builder)SignedRequest.builder().request(toSignRequest.request())).payload(toSignRequest.payload().isPresent() ? (ContentStreamProvider)toSignRequest.payload().get() : null)).build();
        }
        Identity identity = toSignRequest.identity();
        if (this.checkIfCredsNull((AwsCredentials)identity)) {
            return null;
        }
        RazAnonymousAWSCredentialsProvider.RazAnonymousAWSCredential credentialToCommunicateWithRaz = this.getCredentialToCommunicateWithRaz((AwsCredentials)identity);
        RazDelegationTokenBinding dtBinding = credentialToCommunicateWithRaz.getDelegationTokenBinding();
        RangerRazClient razClient = this.getRazClient(credentialToCommunicateWithRaz);
        UserGroupInformation owner = credentialToCommunicateWithRaz.getOwner();
        String userName = owner.getUserName();
        String razToken = this.getAccessTokenAndLog(dtBinding, owner, userName);
        BucketRegionCache bucketRegionCache = credentialToCommunicateWithRaz.getBucketRegionCache();
        String bucketName = S3Utils.getBucketNameFromHost(request.host());
        Objects.requireNonNull(bucketName, "Unable to look up bucketname from hostname=[" + request.host() + "]");
        if (this.checkIfS3ExpressBucket(bucketName)) {
            request = this.addCheckSumToRequest(request);
        }
        String regionName = bucketRegionCache.get(bucketName);
        Configuration configuration = credentialToCommunicateWithRaz.getConfig();
        byte[] contentBytes = this.getContentBytes(request);
        AwsRequestParserV2 requestParser = new AwsRequestParserV2();
        AwsRequest awsRequest = requestParser.parseAwsRequest((CloudHttpRequest)new S3CloudHttpRequest(request));
        AwsRequestCacheKey awsRequestCacheKey = this.getAwsRequestCacheKey(request, userName);
        SignerCache<AwsRequestCacheKey, Map<String, String>> cache = credentialToCommunicateWithRaz.getSignerCache();
        Map<String, String> cachedSignedHeaders = cache.get(awsRequestCacheKey);
        if (cachedSignedHeaders == null) {
            SignRequestImpl signRequest = this.getSignRequest(new S3CloudHttpRequest(request), contentBytes);
            HashMap<String, String> rContext = new HashMap<String, String>();
            try {
                String signReq = ProtoConverters.toBase64((SignRequest)signRequest);
                rContext.put("S3_SIGN_REQUEST", signReq);
            }
            catch (IOException e) {
                throw new RuntimeException("Can't convert sign request to protobuffed base64.", e);
            }
            RangerRazRequest razRequest = RazS3SignerPlugin.getRangerRazRequestWithSetup(configuration, rContext, userName, this.retrieveOperationName(awsRequest));
            RangerRazResult rangerRazResult = null;
            SignResponse signResponse = null;
            try {
                rangerRazResult = razClient.checkPrivilege(razRequest, razToken);
                if (rangerRazResult == null) {
                    if (!this.isKerberosAuthenticated()) {
                        throw new RuntimeException("User: " + userName + " doesn't have Kerberos Authentication.");
                    }
                    throw new RuntimeException("User: " + userName + " have kinited but RAZ server may be down. Please verify if RAZ server is up or not.");
                }
            }
            catch (RangerRazException e) {
                LOG.debug("Got exception from RAZ server, checking if this is InvalidToken error");
                if (e.getErrorCode().equals((Object)RangerRazErrorCode.RAZ_CLIENT_ACCESS_DENIED) && e.getMessage().contains("InvalidToken")) {
                    LOG.debug("InvalidToken error, trying to update token from UGI and retry");
                    dtBinding.maybeRefreshRazToken();
                    String updatedToken = dtBinding.getRazToken().getAccessToken();
                    try {
                        rangerRazResult = razClient.checkPrivilege(razRequest, updatedToken);
                    }
                    catch (RangerRazException rangerRazException) {
                        LOG.error("Exception while checking privilege, RazRequestID: " + razRequest.getRequestId(), (Throwable)e);
                        throw new RazS3ClientCredentialsException(e.getMessage(), e);
                    }
                }
                this.rangerRazExceptionToASEAndThrow(e, razRequest.getRequestId());
                LOG.error("Exception while checking privilege, RazRequestID: " + razRequest.getRequestId(), (Throwable)e);
                throw new RazS3ClientCredentialsException(e.getMessage(), e);
            }
            RangerRazResultBase.AccessResult accessResult = rangerRazResult.getOperResult().getResult();
            switch (accessResult) {
                case ALLOWED: {
                    break;
                }
                case DENIED: 
                case NOT_DETERMINED: {
                    throw this.constructAccessDeniedException(rangerRazResult, userName);
                }
                default: {
                    throw new UnsupportedOperationException("Unknown operation result from RAZ: " + accessResult);
                }
            }
            try {
                String signResponseStr = (String)rangerRazResult.getOperResult().getAdditionalInfo().get("S3_SIGN_RESPONSE");
                signResponse = ProtoConverters.respFromBase64((String)signResponseStr);
            }
            catch (IOException e) {
                throw new UncheckedIOException("RAZ result cannot be read. request id: " + razRequest.getRequestId() + " exception message: " + e.toString(), e);
            }
            this.maybeUpdateRegionNameInCache(bucketName, regionName, signResponse, bucketRegionCache);
            Map signerGeneratedHeaders = signResponse.getSignerGeneratedHeaders();
            if (awsRequest.isSignatureCachingAllowed()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Caching aws request key : {}", (Object)awsRequestCacheKey);
                }
                cache.put(awsRequestCacheKey, signerGeneratedHeaders);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== Sign request end. Request: {}, Result: {}", (Object)request, (Object)rangerRazResult);
            }
            request = this.addSignedHeadersToRequest(request, signerGeneratedHeaders);
            SignedRequest.Builder signedRequestBuilder = (SignedRequest.Builder)SignedRequest.builder().request((SdkHttpRequest)request);
            if (toSignRequest.payload().isPresent()) {
                signedRequestBuilder.payload(toSignRequest.payload().get());
            }
            return (SignedRequest)signedRequestBuilder.build();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reusing aws request key from cache : {}", (Object)awsRequestCacheKey);
        }
        request = this.addSignedHeadersToRequest(request, cachedSignedHeaders);
        SignedRequest.Builder signedRequestBuilder = (SignedRequest.Builder)SignedRequest.builder().request((SdkHttpRequest)request);
        if (toSignRequest.payload().isPresent()) {
            signedRequestBuilder.payload(toSignRequest.payload().get());
        }
        return (SignedRequest)signedRequestBuilder.build();
    }

    private void addSignedHeaderToRequest(SdkHttpFullRequest.Builder mutableRequest, String headerName, String value) {
        if (listOfSignerHeadersToLogWhenReplaced.contains(headerName) && mutableRequest.headers().containsKey(headerName)) {
            LOG.warn("Original request already contains the header: {}. Replacing...", (Object)headerName);
        }
        mutableRequest.putHeader(headerName, value);
    }

    private SdkHttpFullRequest addSignedHeadersToRequest(SdkHttpFullRequest request, Map<String, String> signedHeaders) {
        SdkHttpFullRequest.Builder mutableRequest = request.toBuilder();
        for (Map.Entry<String, String> entry : signedHeaders.entrySet()) {
            this.addSignedHeaderToRequest(mutableRequest, entry.getKey(), entry.getValue());
        }
        return mutableRequest.build();
    }

    private void maybeUpdateRegionNameInCache(String bucketName, String regionName, SignResponse signResponse, BucketRegionCache bucketRegionCache) {
        if (signResponse.getRegion() != null) {
            if (regionName != null) {
                Preconditions.checkState((boolean)regionName.equalsIgnoreCase(signResponse.getRegion()), (Object)"region and region from signedResponse must match");
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating region in cache for bucket=[{}], from sign response to [{}] ", (Object)bucketName, (Object)signResponse.getRegion());
            }
            bucketRegionCache.put(bucketName, signResponse.getRegion());
        }
    }

    private AccessDeniedException constructAccessDeniedException(RangerRazResult razResult, String username) {
        String msg = String.format("Ranger result: %s, Audit: %s, Username: %s", razResult.getOperResult().getResult(), razResult.getOperResult().getAuditLogs(), username);
        AccessDeniedException ade = (AccessDeniedException)AccessDeniedException.builder().message(msg).statusCode(RCSAWSException.StatusCode.ACCESS_DENIED.getCode()).requestId(razResult.getRequestId()).awsErrorDetails(AwsErrorDetails.builder().errorCode(RCSAWSException.StatusCode.ACCESS_DENIED.name()).build()).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructing AccessDeniedException for RangerRazResult (for raz, not for signer).");
        }
        return ade;
    }

    public static RangerRazRequest getRangerRazRequestWithSetup(Configuration configuration, Map<String, String> rContext, String userName, String operation) {
        RangerRazRequest razRequest = new RangerRazRequest();
        razRequest.setContext(rContext);
        String S3_CONFIG_PREFIX = configuration.get("fs.s3a.ext.raz.prefix", "fs.s3a.ext.raz.");
        String serviceType = configuration.get(S3_CONFIG_PREFIX + SERVICE_TYPE_CONFIG_KEY, DEFAULT_SERVICE_TYPE);
        razRequest.setServiceType(serviceType);
        razRequest.setServiceName(configuration.get(S3_CONFIG_PREFIX + SERVICE_NAME_CONFIG_KEY, DEFAULT_SERVICE_NAME));
        razRequest.setUser(userName);
        razRequest.setKeysToRedact(RangerRazClient.RAZ_CLIENT_KEYS_TO_REDACT);
        RangerRazRequestBase.ResourceAccess resourceAccess = new RangerRazRequestBase.ResourceAccess(new HashMap(), operation);
        razRequest.setOperation(resourceAccess);
        String clusterName = configuration.get(S3_CONFIG_PREFIX + serviceType + CLUSTER_NAME_CONFIG_KEY, "");
        razRequest.setClusterName(clusterName);
        razRequest.setRequestId(String.valueOf(UUID.randomUUID()));
        return razRequest;
    }

    private SignRequestImpl getSignRequest(S3CloudHttpRequest request, byte[] contentBytes) {
        SignRequestImpl signRequest = null;
        try {
            signRequest = new SignRequestImpl(request.getEndpoint(), HttpMethod.valueOf((String)request.method()), request.getHeaders(), request.getParameters(), request.getResourcePath(), contentBytes, 0, null, DEFAULT_SERVICE_TYPE);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error while parsing AWS request endpoint", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sign request: {}", (Object)signRequest);
        }
        return signRequest;
    }

    private AwsRequestCacheKey getAwsRequestCacheKey(SdkHttpFullRequest request, String userName) {
        AwsRequestParserV2 requestParserV2 = new AwsRequestParserV2();
        AwsRequest awsRequest = requestParserV2.parseAwsRequest((CloudHttpRequest)new S3CloudHttpRequest(request));
        AwsRequestCacheKey awsRequestCacheKey = new AwsRequestCacheKey(awsRequest, userName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Incoming request: {} Cache key generated: {} ", (Object)awsRequest, (Object)awsRequestCacheKey);
        }
        return awsRequestCacheKey;
    }

    private byte[] getContentBytes(SdkHttpFullRequest request) {
        byte[] contentBytes = null;
        AwsRequestParserV2 requestParser = new AwsRequestParserV2();
        if (requestParser.isContentSigningRequired((CloudHttpRequest)new S3CloudHttpRequest(request))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content signing required for Request: {}", (Object)request);
            }
            try {
                contentBytes = requestParser.getRequestContents((CloudHttpRequest)new S3CloudHttpRequest(request));
            }
            catch (IOException e) {
                throw new RCSAWSException(RCSAWSException.StatusCode.OTHER, "Unable to extract request contents for request: [" + request + "]", (Exception)e);
            }
        }
        return contentBytes;
    }

    private String getAccessTokenAndLog(RazDelegationTokenBinding dtBinding, UserGroupInformation owner, String userName) {
        String razToken = null;
        if (dtBinding.getRazToken() != null) {
            razToken = dtBinding.getRazToken().getAccessToken();
        }
        if (LOG.isDebugEnabled()) {
            if (!StringUtils.isEmpty((String)razToken)) {
                LOG.debug("razToken: {}, owner: {}, userName: {}", new Object[]{razToken.substring(0, 6), owner, userName});
            } else {
                LOG.debug("No razToken found, owner: {}, userName: {}", (Object)owner, (Object)userName);
            }
        }
        return razToken;
    }

    private RangerRazClient getRazClient(RazAnonymousAWSCredentialsProvider.RazAnonymousAWSCredential credentialToCommunicateWithRaz) {
        RangerRazClient razClient = credentialToCommunicateWithRaz.getRazClient();
        if (razClient == null) {
            throw new RuntimeException("Raz client from DT binding is null.");
        }
        return razClient;
    }

    private RazAnonymousAWSCredentialsProvider.RazAnonymousAWSCredential getCredentialToCommunicateWithRaz(AwsCredentials credentials) {
        if (!(credentials instanceof RazAnonymousAWSCredentialsProvider.RazAnonymousAWSCredential)) {
            String eMsg = String.format("Credentials are not an instance of %s, classname: %s, toString: %s", RazAnonymousAWSCredentialsProvider.class.getName(), credentials.getClass().getName(), credentials.toString());
            throw new CredentialInitializationException(eMsg);
        }
        return (RazAnonymousAWSCredentialsProvider.RazAnonymousAWSCredential)credentials;
    }

    private boolean checkIfCredsNull(AwsCredentials credentials) {
        if (credentials == null || credentials.secretAccessKey() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Secret key is null from credentials. Returning from the signer without signing the request.");
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public String retrieveOperationName(AwsRequest request) {
        try {
            String referrerHeader = (String)request.getHeaders().get(REFERER_HEADER);
            String opName = this.parseReferrerHeader(referrerHeader).get(OP_NAME_KEY);
            return this.getOpNameWithoutPrefix(opName);
        }
        catch (Exception ex) {
            LOG.warn("Exception occurred while finding Referer header from incoming request.So setting to {}", (Object)"UNKNOWN_AWS_OPERATION", (Object)ex);
            return "UNKNOWN_AWS_OPERATION";
        }
    }

    @VisibleForTesting
    public HashMap<String, String> parseReferrerHeader(String referrerHeader) {
        int equals;
        HashMap<String, String> referrerHeaderMap = new HashMap<String, String>();
        if (referrerHeader == null || referrerHeader.length() == 0) {
            LOG.debug("This is an empty string or null string, expected a valid string to parse");
            return referrerHeaderMap;
        }
        int indexOfQuestionMark = referrerHeader.indexOf("?");
        String httpReferrer = referrerHeader.substring(indexOfQuestionMark + 1, referrerHeader.length() - 1);
        int lengthOfReferrer = httpReferrer.length();
        int start = 0;
        LOG.debug("HttpReferrer headers string: {}", (Object)httpReferrer);
        while (start < lengthOfReferrer && (equals = httpReferrer.indexOf("=", start)) != -1) {
            String key = httpReferrer.substring(start, equals);
            int end = httpReferrer.indexOf("&", equals);
            if (end == -1) {
                end = lengthOfReferrer;
            }
            String value = httpReferrer.substring(equals + 1, end);
            referrerHeaderMap.put(key, value);
            start = end + 1;
        }
        LOG.debug("HttpReferrer headers map:{}", referrerHeaderMap);
        return referrerHeaderMap;
    }

    @VisibleForTesting
    public String getOpNameWithoutPrefix(String opName) {
        return opName.startsWith(PREFIX_TO_TRUNCATE) ? opName.substring(PREFIX_TO_TRUNCATE.length()) : opName;
    }

    private void rangerRazExceptionToASEAndThrow(RangerRazException e, String razRequestId) {
        Map exceptionHeaderMap = e.getRangerRazExceptionHeadersMap();
        if (exceptionHeaderMap != null && exceptionHeaderMap.containsKey("x-ranger-amz-status-code")) {
            AwsErrorDetails.Builder errorDetails = AwsErrorDetails.builder().errorMessage(e.getMessage() + ", RazRequestID: " + razRequestId).serviceName("Amazon S3");
            AwsServiceException.Builder ase = AwsServiceException.builder().requestId(razRequestId);
            if (exceptionHeaderMap.containsKey("x-ranger-amz-error-code")) {
                errorDetails.errorCode((String)exceptionHeaderMap.get("x-ranger-amz-error-code"));
            }
            if (exceptionHeaderMap.containsKey("x-ranger-amz-status-code")) {
                String statusCodeStr = (String)exceptionHeaderMap.get("x-ranger-amz-status-code");
                try {
                    ase.statusCode(Integer.parseInt(statusCodeStr));
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.error("String: " + statusCodeStr + " can't be parsed into an Integer.");
                    ase.statusCode(400);
                }
            }
            if (exceptionHeaderMap.containsKey("x-ranger-amz-request-id")) {
                ase.requestId((String)exceptionHeaderMap.get("x-ranger-amz-request-id"));
            }
            if (exceptionHeaderMap.containsKey("x-ranger-amz-id-2")) {
                ase.extendedRequestId((String)exceptionHeaderMap.get("x-ranger-amz-id-2"));
            }
            throw ase.awsErrorDetails(errorDetails.build()).build();
        }
    }

    private boolean isKerberosAuthenticated() {
        try {
            UserGroupInformation loggedInUser = UserGroupInformation.getLoginUser();
            boolean isSecurityEnabled = UserGroupInformation.isSecurityEnabled();
            boolean hasKerberosCredentials = loggedInUser.hasKerberosCredentials();
            UserGroupInformation.AuthenticationMethod loggedInUserAuthMethod = loggedInUser.getAuthenticationMethod();
            return isSecurityEnabled && hasKerberosCredentials && loggedInUserAuthMethod.equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get authentication details, Exception: " + e.toString());
        }
    }

    @VisibleForTesting
    public void translateToASEAndThrow(RangerRazException e, String razRequestId) {
        this.rangerRazExceptionToASEAndThrow(e, razRequestId);
    }
}

