/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.hook.s3;

import java.io.IOException;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.ranger.raz.hook.s3.RazDelegationTokenBinding;
import org.apache.ranger.raz.hook.s3.RazS3ATokenIdentifier;
import org.apache.ranger.raz.hook.s3.RazToken;
import org.apache.ranger.raz.intg.RangerRazException;
import org.apache.ranger.raz.intg.client.RangerRazClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RazS3ATokenRenewer
extends TokenRenewer {
    private static final Logger LOG = LoggerFactory.getLogger(RazS3ATokenRenewer.class);
    private static final String ERR_INVALID_RENEWER = "The user (%s) does not match the renewer declared for the token: %s";

    public boolean handleKind(Text text) {
        return RazS3ATokenIdentifier.RAZ_TOKEN_KIND.equals((Object)text);
    }

    public boolean isManaged(Token<?> token) throws IOException {
        return this.handleKind(token.getKind());
    }

    public long renew(Token<?> token, Configuration configuration) throws IOException, InterruptedException {
        long expiry = 0L;
        TokenIdentifier identifier = token.decodeIdentifier();
        if (this.handleKind(identifier.getKind())) {
            LOG.info("Renewing {}", (Object)identifier);
            DelegationTokenIdentifier dtIdentifier = (DelegationTokenIdentifier)identifier;
            LOG.debug("Token: {}", (Object)dtIdentifier);
            expiry = this.getTokenExpiration(dtIdentifier);
            UserGroupInformation user = UserGroupInformation.getCurrentUser();
            if (RazS3ATokenRenewer.validateRenewer(user, dtIdentifier)) {
                RazS3ATokenIdentifier razTokenId = (RazS3ATokenIdentifier)dtIdentifier;
                RazToken razToken = razTokenId.getRazToken();
                RangerRazClient razClient = this.getRazClient(user, configuration);
                try {
                    expiry = razClient.renewDelegationToken(razToken.getAccessToken());
                }
                catch (RangerRazException e) {
                    throw new IOException("Error during DT renewal from RAZ server: " + (Object)((Object)e), e);
                }
                if (expiry == -1L) {
                    LOG.error("Token {} could not be renewed.", (Object)identifier.getKind());
                    throw new IOException(String.format("Token {%s} could not be renewed", identifier.getKind()));
                }
            } else {
                this.throwInvalidRenewerException(user.getShortUserName(), identifier.getKind());
            }
        } else {
            LOG.error("Token kind {} can not be handled ", (Object)identifier.getKind());
        }
        return expiry;
    }

    private void throwInvalidRenewerException(String user, Text tokenKind) throws IOException {
        throw new IOException(String.format(ERR_INVALID_RENEWER, user, tokenKind));
    }

    private RangerRazClient getRazClient(UserGroupInformation owner, Configuration configuration) throws IOException {
        return RazDelegationTokenBinding.createRazClient(configuration, owner);
    }

    private static boolean validateRenewer(UserGroupInformation candidate, DelegationTokenIdentifier identifier) throws IllegalArgumentException {
        boolean isValid = true;
        Text declaredRenewer = identifier.getRenewer();
        if (declaredRenewer != null && declaredRenewer.getLength() > 0) {
            if (!declaredRenewer.toString().equals(candidate.getShortUserName())) {
                LOG.error(String.format(Locale.getDefault(), ERR_INVALID_RENEWER, candidate.getUserName(), declaredRenewer));
                isValid = false;
            }
        } else {
            LOG.error("Operation not permitted. No renewer is specified in the identifier.");
            isValid = false;
        }
        return isValid;
    }

    private long getTokenExpiration(DelegationTokenIdentifier dtIdentifier) {
        return ((RazS3ATokenIdentifier)dtIdentifier).getExpiryTime();
    }

    public void cancel(Token<?> token, Configuration configuration) throws IOException {
        block6: {
            TokenIdentifier identifier = token.decodeIdentifier();
            if (this.handleKind(identifier.getKind())) {
                LOG.info("Cancelling {}", (Object)identifier);
                DelegationTokenIdentifier dtIdentifier = (DelegationTokenIdentifier)identifier;
                LOG.debug("Token: {}", (Object)dtIdentifier);
                UserGroupInformation user = UserGroupInformation.getCurrentUser();
                if (RazS3ATokenRenewer.validateRenewer(user, dtIdentifier)) {
                    RazS3ATokenIdentifier razTokenId = (RazS3ATokenIdentifier)dtIdentifier;
                    RazToken razToken = razTokenId.getRazToken();
                    RangerRazClient razClient = this.getRazClient(user, configuration);
                    Boolean cancellationResult = false;
                    try {
                        cancellationResult = razClient.cancelDelegationToken(razToken.getAccessToken());
                        if (!cancellationResult.booleanValue()) {
                            throw new IOException(String.format("Token kind %s could not be cancelled.", identifier.getKind()));
                        }
                        break block6;
                    }
                    catch (RangerRazException e) {
                        throw new IOException("Error during DT renewal from RAZ server: " + (Object)((Object)e), e);
                    }
                }
                this.throwInvalidRenewerException(user.getShortUserName(), identifier.getKind());
            } else {
                LOG.error("Token kind {} can not be handled", (Object)identifier.getKind());
            }
        }
    }
}

