/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.hook.s3;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.io.Text;
import org.apache.ranger.raz.hook.s3.RazToken;

public class RazS3ATokenIdentifier
extends AbstractS3ATokenIdentifier {
    private RazToken razToken;
    private static final long serialVersionUID = 4L;
    static final String RAZ_TOKEN_NAME = "S3ADelegationToken/Raz";
    static final Text RAZ_TOKEN_KIND = new Text("S3ADelegationToken/Raz");

    public RazS3ATokenIdentifier() {
        super(RAZ_TOKEN_KIND);
    }

    public RazS3ATokenIdentifier(Text kind, Text owner, Text renewer, URI uri, String origin, EncryptionSecrets encryptionSecrets, RazToken razToken) {
        super(kind, uri, owner, renewer, origin, encryptionSecrets);
        this.razToken = razToken;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.razToken.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.razToken = new RazToken();
        this.razToken.readFields(in);
    }

    public long getExpiryTime() {
        return this.razToken.getExpiryTime();
    }

    public RazToken getRazToken() {
        return this.razToken;
    }
}

