/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.hook.s3;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.auth.RoleModel;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractDelegationTokenBinding;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.ranger.raz.hook.s3.RazAnonymousAWSCredentialsProvider;
import org.apache.ranger.raz.hook.s3.RazS3ATokenIdentifier;
import org.apache.ranger.raz.hook.s3.RazToken;
import org.apache.ranger.raz.hook.s3.utils.TokenUtils;
import org.apache.ranger.raz.intg.RangerRazException;
import org.apache.ranger.raz.intg.client.RangerRazClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class RazDelegationTokenBinding
extends AbstractDelegationTokenBinding {
    private static final String NAME = "RazDelegationToken";
    public static final String RAZ_S3_CONFIG_PREFIX_NAME = "fs.s3a.ext.raz.prefix";
    public static final String RAZ_S3_CONFIG_PREFIX_DEFAULT = "fs.s3a.ext.raz.";
    private static final Logger LOG = LoggerFactory.getLogger(RazDelegationTokenBinding.class);
    private RazToken razToken;
    private AWSCredentialProviderList credentialProviders;
    private RangerRazClient razClient;

    protected RazDelegationTokenBinding(String name, Text kind) {
        super(name, kind);
    }

    public RazDelegationTokenBinding() {
        this(NAME, RazS3ATokenIdentifier.RAZ_TOKEN_KIND);
    }

    public AbstractS3ATokenIdentifier createTokenIdentifier(Optional<RoleModel.Policy> policy, EncryptionSecrets encryptionSecrets, Text renewer) throws IOException {
        LOG.debug("Creating token identifier.");
        this.checkRazClientInitialized();
        RazToken razTokenBonded = this.requestRazAccessToken(renewer.toString());
        String dtServiceName = this.razClient.getDelegationTokenServiceName();
        RazS3ATokenIdentifier identifier = new RazS3ATokenIdentifier(RazS3ATokenIdentifier.RAZ_TOKEN_KIND, this.getOwnerText(), renewer, this.getCanonicalUri(), "Created from " + dtServiceName, encryptionSecrets, razTokenBonded);
        LOG.debug("Created token identifier. Owner: {}; Bucket: {}", (Object)identifier.getOwner(), (Object)identifier.getBucket());
        return identifier;
    }

    public AWSCredentialProviderList deployUnbonded() throws IOException {
        LOG.debug("Deploy Unbonded.");
        this.razToken = null;
        return this.getAwsCredentialProviderList();
    }

    public AbstractS3ATokenIdentifier createEmptyIdentifier() {
        return new RazS3ATokenIdentifier();
    }

    public AWSCredentialProviderList bindToTokenIdentifier(AbstractS3ATokenIdentifier retrievedIdentifier) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Binding to retrieved token: {}", (Object)retrievedIdentifier.toString());
        }
        RazS3ATokenIdentifier tokenIdentifier = (RazS3ATokenIdentifier)this.convertTokenIdentifier(retrievedIdentifier, RazS3ATokenIdentifier.class);
        tokenIdentifier.validate();
        this.razToken = tokenIdentifier.getRazToken();
        return this.getAwsCredentialProviderList();
    }

    private AWSCredentialProviderList getAwsCredentialProviderList() {
        this.credentialProviders = new AWSCredentialProviderList();
        S3AFileSystem fs = this.getFileSystem();
        UserGroupInformation owner = fs.createStoreContext().getOwner();
        RazAnonymousAWSCredentialsProvider razAnonymousAWSCredentialsProvider = new RazAnonymousAWSCredentialsProvider(this, owner, this.getConfig(), this.razClient);
        this.credentialProviders.add((AwsCredentialsProvider)razAnonymousAWSCredentialsProvider);
        return this.credentialProviders;
    }

    protected void serviceStop() throws Exception {
        super.serviceStop();
        this.razClient = null;
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.razClient = RazDelegationTokenBinding.createRazClient(this.getConfig(), this.getOwner());
    }

    private RazToken requestRazAccessToken(String renewer) throws IOException {
        LOG.debug("Requesting initial Raz delegation token");
        this.checkRazClientInitialized();
        RazToken retrievedToken = null;
        Token ret = new Token();
        try {
            String razDT = this.razClient.getDelegationToken(renewer);
            ret.decodeFromUrlString(razDT);
            DelegationTokenIdentifier delegationTokenIdentifier = (DelegationTokenIdentifier)ret.decodeIdentifier();
            retrievedToken = new RazToken(delegationTokenIdentifier.getIssueDate(), delegationTokenIdentifier.getMaxDate(), razDT);
            LOG.debug("Got token from raz server via client.");
        }
        catch (RangerRazException e) {
            throw new IOException("Error while getting token from raz server.", e);
        }
        return retrievedToken;
    }

    private void checkRazClientInitialized() {
        if (this.razClient == null) {
            throw new ServiceStateException("Raz client is not initialized. The service should be started with " + ((Object)((Object)this)).getClass().getSimpleName() + ".start() so the raz client will be initialized properly.");
        }
    }

    protected static RangerRazClient createRazClient(Configuration config, UserGroupInformation owner) throws IOException {
        String configPrefix = config.get(RAZ_S3_CONFIG_PREFIX_NAME, RAZ_S3_CONFIG_PREFIX_DEFAULT);
        config.set("ranger.raz.client.prefix", configPrefix);
        return RangerRazClient.getInstance((Configuration)config, (UserGroupInformation)owner);
    }

    public RazToken getRazToken() {
        return this.razToken;
    }

    public void maybeRefreshRazToken() {
        RazS3ATokenIdentifier token = this.fetchUpdatedTokenFromUGI();
        if (token != null && !this.razToken.getAccessToken().equals(token.getRazToken().getAccessToken())) {
            this.razToken = token.getRazToken();
            LOG.info("Updated raz token from UGI in DT binding.");
        }
    }

    private RazS3ATokenIdentifier fetchUpdatedTokenFromUGI() {
        Text serviceName = new Text(this.getCanonicalUri().toString());
        try {
            Token token = TokenUtils.lookupToken(UserGroupInformation.getCurrentUser().getCredentials(), serviceName, RazS3ATokenIdentifier.RAZ_TOKEN_KIND);
            if (token == null) {
                LOG.debug("No raz token found in UGI");
            }
            return token != null ? (RazS3ATokenIdentifier)token.decodeIdentifier() : null;
        }
        catch (IOException e) {
            LOG.debug("Exception while fetching updated raz token from UGI, will keep using older token", (Throwable)e);
            return null;
        }
    }
}

