/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.hook.s3;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.raz.hook.s3.RazDelegationTokenBinding;
import org.apache.ranger.raz.hook.s3.cache.BucketRegionCache;
import org.apache.ranger.raz.hook.s3.cache.SignerCache;
import org.apache.ranger.raz.hook.s3.cache.SignerCacheImpl;
import org.apache.ranger.raz.intg.client.RangerRazClient;
import org.apache.ranger.raz.s3.lib.aws.fsrequests.AwsRequestCacheKey;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class RazAnonymousAWSCredentialsProvider
implements AwsCredentialsProvider {
    private final RazDelegationTokenBinding razDelegationTokenBinding;
    private final UserGroupInformation owner;
    private final Configuration configuration;
    private static final String SIGNATURE_CACHE_MAX_SIZE = "fs.s3a.signature.cache.max.size";
    private static final String SIGNATURE_CACHE_EXPIRY_SECONDS = "fs.s3a.signature.cache.expiry.sec";
    private final SignerCache<AwsRequestCacheKey, Map<String, String>> signerCache;
    private final BucketRegionCache bucketRegionCache;
    private final RangerRazClient razClient;

    public RazAnonymousAWSCredentialsProvider(RazDelegationTokenBinding razDT, UserGroupInformation owner, Configuration conf, RangerRazClient razClient) {
        this.razDelegationTokenBinding = razDT;
        this.owner = owner;
        this.configuration = conf;
        this.razClient = razClient;
        long maxSize = conf.getLong(SIGNATURE_CACHE_MAX_SIZE, 100L);
        long expiryInSec = conf.getLong(SIGNATURE_CACHE_EXPIRY_SECONDS, 30L);
        this.signerCache = new SignerCacheImpl(maxSize, expiryInSec);
        this.bucketRegionCache = new BucketRegionCache();
    }

    public AwsCredentials resolveCredentials() {
        return new RazAnonymousAWSCredential();
    }

    public class RazAnonymousAWSCredential
    implements AwsCredentials {
        public String accessKeyId() {
            return "";
        }

        public String secretAccessKey() {
            return "";
        }

        public RazDelegationTokenBinding getDelegationTokenBinding() {
            return RazAnonymousAWSCredentialsProvider.this.razDelegationTokenBinding;
        }

        public RangerRazClient getRazClient() {
            return RazAnonymousAWSCredentialsProvider.this.razClient;
        }

        public UserGroupInformation getOwner() {
            return RazAnonymousAWSCredentialsProvider.this.owner;
        }

        public Configuration getConfig() {
            return RazAnonymousAWSCredentialsProvider.this.configuration;
        }

        public SignerCache<AwsRequestCacheKey, Map<String, String>> getSignerCache() {
            return RazAnonymousAWSCredentialsProvider.this.signerCache;
        }

        public BucketRegionCache getBucketRegionCache() {
            return RazAnonymousAWSCredentialsProvider.this.bucketRegionCache;
        }
    }
}

