/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.hook.abfs;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.BoundDTExtension;
import org.apache.hadoop.fs.azurebfs.extensions.CustomDelegationTokenManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.ranger.raz.intg.RangerRazException;
import org.apache.ranger.raz.intg.client.RangerRazClient;
import org.apache.ranger.raz.intg.client.RangerRazClientLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RazDelegationTokenManager
implements CustomDelegationTokenManager,
BoundDTExtension {
    private static final Logger LOG = LoggerFactory.getLogger(RazDelegationTokenManager.class);
    public static final String ADLS_CONFIG_PREFIX = "fs.azure.ext.raz.prefix";
    public static final String ADLS_CONFIG_PREFIX_DEFAULT = "fs.azure.ext.raz.";
    public static final String CANONICAL_SERVICE_NAME_STRATEGY = "canonical-service-name-strategy";
    public static final String CANONICAL_SERVICE_NAME_STRATEGY_ACCOUNT_ONLY = "ACCOUNT_ONLY";
    public static final String CANONICAL_SERVICE_NAME_STRATEGY_ACCOUNT_AND_CONTAINER = "ACCOUNT_AND_CONTAINER";
    public static final String CANONICAL_SERVICE_NAME_STRATEGY_DEFAULT = "ACCOUNT_ONLY";
    private RangerRazClient rangerRazClient;
    private String canonicalServiceName;
    private String canonicalServiceNameStrategy;

    public void initialize(Configuration configuration) throws IOException {
        UserGroupInformation ugi;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RazDelegationTokenManager.initialize()");
        }
        if ((ugi = UserGroupInformation.getCurrentUser()) == null) {
            String errorMsg = "No user is logged in";
            RangerRazClientLogger.error((Logger)LOG, (String)"RazDelegationTokenManager(): {}", (Object)errorMsg);
            throw new IOException("RazDelegationTokenManager initialization failed: " + errorMsg);
        }
        String configPrefix = configuration.get(ADLS_CONFIG_PREFIX, ADLS_CONFIG_PREFIX_DEFAULT);
        configuration.set("ranger.raz.client.prefix", configPrefix);
        this.canonicalServiceNameStrategy = configuration.get(configPrefix + CANONICAL_SERVICE_NAME_STRATEGY, "ACCOUNT_ONLY");
        if (LOG.isDebugEnabled()) {
            LOG.debug("RazDelegationTokenManager.initialize(): configPrefix=[{}]", (Object)configPrefix);
        }
        this.rangerRazClient = RangerRazClient.getInstance((Configuration)configuration, (UserGroupInformation)ugi);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RazDelegationTokenManager.initialize()");
        }
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RazDelegationTokenManager.getDelegationToken({})", (Object)renewer);
        }
        Token ret = new Token();
        String maskedRazDToken = null;
        try {
            String tokenStr = this.rangerRazClient.getDelegationToken(renewer);
            ret.decodeFromUrlString(tokenStr);
            if (StringUtils.isNotBlank((String)tokenStr)) {
                maskedRazDToken = "********";
            }
        }
        catch (RangerRazException excp) {
            RangerRazClientLogger.error((Logger)LOG, (String)"failed to get delegation token", (Throwable)excp);
            throw new IOException(excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RazDelegationTokenManager.getDelegationToken({}): ret={}", (Object)renewer, (Object)maskedRazDToken);
        }
        return ret;
    }

    public long renewDelegationToken(Token<?> token) throws IOException {
        String maskedRazDToken = null;
        long ret = 0L;
        String tokenStr = token.encodeToUrlString();
        if (StringUtils.isNotBlank((String)tokenStr)) {
            maskedRazDToken = "********";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RazDelegationTokenManager.renewDelegationToken({})", (Object)maskedRazDToken);
        }
        try {
            ret = this.rangerRazClient.renewDelegationToken(tokenStr);
        }
        catch (RangerRazException excp) {
            RangerRazClientLogger.error((Logger)LOG, (String)"failed to renew delegation token", (Throwable)excp);
            throw new IOException(excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RazDelegationTokenManager.renewDelegationToken(): ret={}", (Object)ret);
        }
        return ret;
    }

    public void cancelDelegationToken(Token<?> token) throws IOException {
        String maskedRazDToken = null;
        String tokenStr = token.encodeToUrlString();
        if (StringUtils.isNotBlank((String)tokenStr)) {
            maskedRazDToken = "********";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RazDelegationTokenManager.cancelDelegationToken({})", (Object)maskedRazDToken);
        }
        try {
            this.rangerRazClient.cancelDelegationToken(tokenStr);
        }
        catch (RangerRazException excp) {
            RangerRazClientLogger.error((Logger)LOG, (String)"failed to cancel delegation token", (Throwable)excp);
            throw new IOException(excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RazDelegationTokenManager.cancelDelegationToken()");
        }
    }

    public void close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("===>> RazDelegationTokenManager.close(): Nothing to clean related to Delegation token.");
        }
    }

    public void bind(URI fsURI, Configuration conf) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("===>> RazDelegationTokenManager.bind({}, {})", (Object)fsURI, (Object)conf);
        }
        this.canonicalServiceName = CANONICAL_SERVICE_NAME_STRATEGY_ACCOUNT_AND_CONTAINER.equalsIgnoreCase(this.canonicalServiceNameStrategy) ? fsURI.toString() : "abfs://" + fsURI.getHost() + "/";
        if (LOG.isDebugEnabled()) {
            LOG.debug("<<=== RazDelegationTokenManager.bind(): setting this.canonicalServiceName={}", (Object)this.canonicalServiceName);
        }
    }

    public String getCanonicalServiceName() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("===>> RazDelegationTokenManager.getCanonicalServiceName()");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<<=== RazDelegationTokenManager.getCanonicalServiceName(): ret={}", (Object)this.canonicalServiceName);
        }
        return this.canonicalServiceName;
    }
}

