/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.hook.abfs;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.ranger.raz.intg.RangerRazErrorCode;
import org.apache.ranger.raz.intg.RangerRazException;
import org.apache.ranger.raz.intg.client.RangerRazClient;
import org.apache.ranger.raz.intg.client.RangerRazClientLogger;
import org.apache.ranger.raz.model.RangerRazRequest;
import org.apache.ranger.raz.model.RangerRazRequestBase;
import org.apache.ranger.raz.model.RangerRazResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerRazTokenProvider
implements SASTokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerRazTokenProvider.class);
    public static final String ADLS_RESOURCE_STORAGE_ACCOUNT = "storageaccount";
    public static final String ADLS_RESOURCE_CONTAINER = "container";
    public static final String ADLS_RESOURCE_RELATIVE_PATH = "relativepath";
    public static final String CONF_DELEGATION_TOKEN_KIND = "delegation-token.token-kind";
    public static final String CONF_ADLS_SERVICE_TYPE = "adls.service.type";
    public static final String DELEGATION_TOKEN_KIND_DEFAULT = "raz-dt";
    public static final String ADLS_SERVICE_TYPE_DEFAULT = "adls";
    public static final String ADLS_CONFIG_PREFIX = "fs.azure.ext.raz.prefix";
    public static final String ADLS_CONFIG_PREFIX_DEFAULT = "fs.azure.ext.raz.";
    public static final String CONF_CLUSTER_NAME = ".access.cluster.name";
    public static final String CONF_CLUSTER_TYPE = ".access.cluster.type";
    public static final String ADDL_INFO_KET_ADLS_DSAS = "ADLS_DSAS";
    public static final String CANONICAL_SERVICE_NAME_STRATEGY = "canonical-service-name-strategy";
    public static final String CANONICAL_SERVICE_NAME_STRATEGY_ACCOUNT_ONLY = "ACCOUNT_ONLY";
    public static final String CANONICAL_SERVICE_NAME_STRATEGY_ACCOUNT_AND_CONTAINER = "ACCOUNT_AND_CONTAINER";
    public static final String CANONICAL_SERVICE_NAME_STRATEGY_DEFAULT = "ACCOUNT_ONLY";
    private String serviceType = "adls";
    private String clusterName;
    private String clusterType;
    private String userName;
    private String delegationToken;
    private String tokenKindStr;
    private String canonicalServiceNameStrategy;
    private RangerRazClient razClient;

    public void initialize(Configuration configuration, String accountName) throws IOException {
        UserGroupInformation ugi;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazTokenProvider.initialize(accountName={})", (Object)accountName);
        }
        if ((ugi = UserGroupInformation.getCurrentUser()) == null) {
            String errorMsg = "no user is logged in";
            RangerRazClientLogger.error((Logger)LOG, (String)"RangerRazTokenProvider(): {}", (Object)errorMsg);
            throw new IOException("RangerRazTokenProvider initialization failed: " + errorMsg);
        }
        String configPrefix = configuration.get(ADLS_CONFIG_PREFIX, ADLS_CONFIG_PREFIX_DEFAULT);
        configuration.set("ranger.raz.client.prefix", configPrefix);
        this.tokenKindStr = configuration.get(configPrefix + CONF_DELEGATION_TOKEN_KIND, DELEGATION_TOKEN_KIND_DEFAULT);
        this.serviceType = configuration.get(configPrefix + CONF_ADLS_SERVICE_TYPE, ADLS_SERVICE_TYPE_DEFAULT);
        this.clusterName = configuration.get(configPrefix + this.serviceType + CONF_CLUSTER_NAME, "");
        this.clusterType = configuration.get(configPrefix + this.serviceType + CONF_CLUSTER_TYPE, "");
        this.canonicalServiceNameStrategy = configuration.get(configPrefix + CANONICAL_SERVICE_NAME_STRATEGY, "ACCOUNT_ONLY");
        this.userName = RangerRazTokenProvider.getUserNameFromUGI(ugi);
        this.delegationToken = RangerRazTokenProvider.getDelegationTokenFromUGI(ugi, this.tokenKindStr);
        this.razClient = RangerRazClient.getInstance((Configuration)configuration, (UserGroupInformation)ugi);
        if (LOG.isDebugEnabled()) {
            LOG.debug("RangerRazTokenProvider.initialize(): configPrefix={}", (Object)configPrefix);
            LOG.debug("RangerRazTokenProvider.initialize(): {}={}", (Object)CONF_DELEGATION_TOKEN_KIND, (Object)this.tokenKindStr);
            LOG.debug("RangerRazTokenProvider.initialize(): {}={}", (Object)CONF_ADLS_SERVICE_TYPE, (Object)this.serviceType);
            LOG.debug("RangerRazTokenProvider.initialize(): {}={}", (Object)(this.serviceType + CONF_CLUSTER_NAME), (Object)this.clusterName);
            LOG.debug("RangerRazTokenProvider.initialize(): {}={}", (Object)(this.serviceType + CONF_CLUSTER_TYPE), (Object)this.clusterType);
            LOG.debug("<== RangerRazTokenProvider.initialize(accountName={})", (Object)accountName);
        }
    }

    public String getSASToken(String account, String fileSystem, String path, String operation) throws IOException, AccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazTokenProvider.getSASToken({}, {}, {}, {})", new Object[]{account, fileSystem, path, operation});
            AzureBlobFileSystem.printStatistics();
        }
        String ret = null;
        Map<String, String> resource = RangerRazTokenProvider.createRazResource(account, fileSystem, path);
        HashSet<String> accessTypes = new HashSet<String>();
        accessTypes.add(operation);
        RangerRazRequestBase.ResourceAccess resourceAccess = new RangerRazRequestBase.ResourceAccess(resource, account, operation, accessTypes);
        RangerRazRequest razRequest = new RangerRazRequest(this.serviceType, resourceAccess, this.userName);
        razRequest.setClusterName(this.clusterName);
        razRequest.setClusterType(this.clusterType);
        try {
            RangerRazResult result = this.razClient.checkPrivilege(razRequest, this.delegationToken);
            ret = this.getDSASTokenFromResult(result);
        }
        catch (RangerRazException excp) {
            if (excp.getErrorCode() == RangerRazErrorCode.RAZ_CLIENT_ACCESS_DENIED) {
                if (excp.getMessage().contains("InvalidToken")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("InvalidToken delegationToken error, trying to update delegationToken from UGI and retry");
                    }
                    try {
                        String serviceName = this.getCanonicalServiceName(account);
                        String updatedToken = this.maybeRefreshRazToken(serviceName, this.tokenKindStr, this.delegationToken);
                        RangerRazResult result = this.razClient.checkPrivilege(razRequest, updatedToken);
                        ret = this.getDSASTokenFromResult(result);
                    }
                    catch (RangerRazException rangerRazException) {
                        LOG.error("Exception while checking privilege new delegationToken, RazRequestID: " + razRequest.getRequestId(), (Throwable)rangerRazException);
                        throw new AccessControlException((Throwable)rangerRazException);
                    }
                }
                RangerRazClientLogger.error((Logger)LOG, (String)"Failed to get DSAS token from Raz", (Throwable)excp);
                throw new AccessControlException();
            }
            throw new AccessControlException((Throwable)excp);
        }
        return ret;
    }

    private String getDSASTokenFromResult(RangerRazResult result) {
        String ret = null;
        if (result != null && result.getOperResult() != null) {
            Map additionalInfo;
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerRazTokenProvider.getSASToken(): result=" + result);
            }
            if ((additionalInfo = result.getOperResult().getAdditionalInfo()) != null) {
                ret = (String)additionalInfo.get(ADDL_INFO_KET_ADLS_DSAS);
            }
        }
        return ret;
    }

    private static Map<String, String> createRazResource(String account, String container, String path) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        ret.put(ADLS_RESOURCE_STORAGE_ACCOUNT, account);
        ret.put(ADLS_RESOURCE_CONTAINER, container);
        ret.put(ADLS_RESOURCE_RELATIVE_PATH, path);
        return ret;
    }

    private static String getUserNameFromUGI(UserGroupInformation ugi) throws AccessControlException {
        String ret;
        String string = ret = ugi != null ? ugi.getShortUserName() : null;
        if (ret == null) {
            String errorMsg = "Failed to obtain currently logged in user";
            RangerRazClientLogger.error((Logger)LOG, (String)errorMsg);
            throw new AccessControlException(errorMsg);
        }
        return ret;
    }

    public static String getDelegationTokenFromUGI(UserGroupInformation ugi, String tokenKindStr) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazTokenProvider.getDelegationTokenFromUGI()");
        }
        String razDToken = null;
        String maskedRazDToken = null;
        try {
            for (Token token : ugi.getTokens()) {
                String tokenKind;
                String string = tokenKind = token != null && token.getKind() != null ? token.getKind().toString() : null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RangerRazTokenProvider.getDelegationTokenFromUGI(): tokenKind={}", (Object)tokenKind);
                }
                if (!tokenKindStr.equalsIgnoreCase(tokenKind)) continue;
                razDToken = token.encodeToUrlString();
                if (LOG.isDebugEnabled()) {
                    maskedRazDToken = RangerRazClient.maskParam((String)razDToken);
                    LOG.debug("RangerRazTokenProvider.getDelegationTokenFromUGI(): found DT=[{}]", (Object)maskedRazDToken);
                }
                break;
            }
        }
        catch (IOException excp) {
            RangerRazClientLogger.error((Logger)LOG, (String)"RangerRazTokenProvider.getDelegationTokenFromUGI(): failed", (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRazTokenProvider.getDelegationTokenFromUGI(): ret={}", maskedRazDToken);
        }
        return razDToken;
    }

    public String maybeRefreshRazToken(String service, String tokenKindStr, String existingToken) {
        String ret = null;
        String newToken = this.fetchUpdatedTokenFromUGI(service, tokenKindStr);
        if (newToken != null && !existingToken.equals(newToken)) {
            this.updateDelegationToken(newToken);
            ret = newToken;
            LOG.info("Updated new raz delegationToken from UGI...");
        }
        return ret;
    }

    private synchronized void updateDelegationToken(String newToken) {
        this.delegationToken = newToken;
    }

    private String fetchUpdatedTokenFromUGI(String service, String tokenKindStr) {
        String ret;
        block3: {
            ret = null;
            Text serviceName = new Text(service);
            Text tokenKindString = new Text(tokenKindStr);
            try {
                UserGroupInformation.logAllUserInfo((Logger)LOG, (UserGroupInformation)UserGroupInformation.getCurrentUser());
                Token token = RangerRazTokenProvider.lookupToken(UserGroupInformation.getCurrentUser().getCredentials(), serviceName, tokenKindString);
                if (token == null && LOG.isDebugEnabled()) {
                    LOG.debug("No ABFS delegationToken found in UGI");
                }
                ret = token != null ? token.encodeToUrlString() : null;
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while fetching updated ABFS delegationToken from UGI, will keep using older token", (Throwable)e);
            }
        }
        return ret;
    }

    private static <T extends DelegationTokenIdentifier> Token<T> lookupToken(Credentials credentials, Text service, Text expectedKind) throws IOException {
        Token token;
        Token ret = null;
        if (expectedKind == null) {
            throw new IllegalArgumentException("expected TokenKind is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for token for service {} in credentials", (Object)service);
        }
        if ((token = credentials.getToken(service)) != null) {
            Text actualKind = token.getKind();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found token of kind {}", (Object)actualKind);
            }
            if (expectedKind.equals((Object)actualKind)) {
                ret = token;
            } else {
                throw new IOException("Token mismatch: expected token for " + service + " of type " + expectedKind + " but got a token of type " + actualKind);
            }
        }
        return ret;
    }

    private String getCanonicalServiceName(String storageAccount) {
        StringBuilder ret = new StringBuilder(storageAccount);
        ret.append(".dfs.core.windows.net");
        ret.append("/");
        if (CANONICAL_SERVICE_NAME_STRATEGY_ACCOUNT_AND_CONTAINER.equalsIgnoreCase(this.canonicalServiceNameStrategy)) {
            return ret.toString();
        }
        return "abfs://" + ret;
    }
}

