/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.raz.hook.abfs;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.oauth2.IdentityTransformer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.ranger.raz.intg.RangerRazException;
import org.apache.ranger.raz.intg.client.RangerRazClient;
import org.apache.ranger.raz.intg.client.RangerRazClientLogger;
import org.apache.ranger.raz.model.RangerRazIdentityMappingsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerRazIdentityTransformer
extends IdentityTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(RangerRazIdentityTransformer.class);
    private static final String ADLS_CONFIG_PREFIX = "fs.azure.ext.raz.prefix";
    private static final String ADLS_CONFIG_PREFIX_DEFAULT = "fs.azure.ext.raz.";
    private static final String CONF_DELEGATION_TOKEN_KIND = "delegation-token.token-kind";
    private static final String DELEGATION_TOKEN_KIND_DEFAULT = "raz-dt";
    private final RangerRazClient rangerRazClient;
    private final String delegationToken;

    public RangerRazIdentityTransformer(Configuration configuration) throws IOException {
        super(configuration);
        UserGroupInformation ugi;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazIdentityTransformer({})", (Object)configuration);
        }
        if ((ugi = UserGroupInformation.getCurrentUser()) == null) {
            String errorMsg = "no user is logged in";
            RangerRazClientLogger.error((Logger)LOG, (String)"RangerRazIdentityTransformer(): {}", (Object)errorMsg);
            throw new IOException("RangerRazIdentityTransformer initialization failed: " + errorMsg);
        }
        String configPrefix = configuration.get(ADLS_CONFIG_PREFIX, ADLS_CONFIG_PREFIX_DEFAULT);
        configuration.set("ranger.raz.client.prefix", configPrefix);
        String tokenKindStr = configuration.get(configPrefix + CONF_DELEGATION_TOKEN_KIND, DELEGATION_TOKEN_KIND_DEFAULT);
        this.delegationToken = RangerRazIdentityTransformer.getDelegationTokenFromUGI(ugi, tokenKindStr);
        this.rangerRazClient = RangerRazClient.getInstance((Configuration)configuration, (UserGroupInformation)ugi);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRazIdentityTransformer()");
        }
    }

    public String transformIdentityForGetRequest(String originalIdentity, boolean isUserName, String localIdentity) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazIdentityTransformer.transformIdentityForGetRequest({}, {}, {})", new Object[]{originalIdentity, isUserName, localIdentity});
        }
        String clusterId = null;
        try {
            RangerRazIdentityMappingsUtil razIdMappingsUtil = this.rangerRazClient.getIdentityMappingUtil(this.delegationToken);
            clusterId = isUserName ? razIdMappingsUtil.getUserClusterId(originalIdentity) : razIdMappingsUtil.getGroupClusterId(originalIdentity);
        }
        catch (RangerRazException e) {
            LOG.error("RangerRazIdentityTransformer.transformIdentityForGetRequest(): Exception occured while transforming identity: ", (Throwable)e);
        }
        if (StringUtils.isBlank(clusterId)) {
            clusterId = super.transformIdentityForGetRequest(originalIdentity, isUserName, localIdentity);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRazIdentityTransformer.transformIdentityForGetRequest(): clusterId={}", (Object)clusterId);
        }
        return clusterId;
    }

    public String transformUserOrGroupForSetRequest(String userOrGroup) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazIdentityTransformer.transformUserOrGroupForSetRequest({})", (Object)userOrGroup);
        }
        String cloudId = null;
        try {
            RangerRazIdentityMappingsUtil razIdMappingsUtil = this.rangerRazClient.getIdentityMappingUtil(this.delegationToken);
            cloudId = razIdMappingsUtil.getUserCloudId(userOrGroup);
            if (StringUtils.isBlank((String)cloudId)) {
                cloudId = razIdMappingsUtil.getGroupCloudId(userOrGroup);
            }
        }
        catch (RangerRazException e) {
            LOG.error("RangerRazIdentityTransformer.transformUserOrGroupForSetRequest(): Exception occured while transforming user & group: ", (Throwable)e);
        }
        if (StringUtils.isBlank(cloudId)) {
            cloudId = super.transformUserOrGroupForSetRequest(userOrGroup);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRazIdentityTransformer.transformUserOrGroupForSetRequest(): cloudId=", (Object)cloudId);
        }
        return cloudId;
    }

    private static String getDelegationTokenFromUGI(UserGroupInformation ugi, String tokenKindStr) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRazIdentityTransformer.getDelegationTokenFromUGI({}, {})", (Object)ugi, (Object)tokenKindStr);
        }
        String razDToken = null;
        String maskedRazDToken = null;
        try {
            for (Token token : ugi.getTokens()) {
                String tokenKind;
                String string = tokenKind = token != null && token.getKind() != null ? token.getKind().toString() : null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RangerRazIdentityTransformer.getDelegationTokenFromUGI(): tokenKind={}", (Object)tokenKind);
                }
                if (!tokenKindStr.equalsIgnoreCase(tokenKind)) continue;
                razDToken = token.encodeToUrlString();
                if (LOG.isDebugEnabled()) {
                    maskedRazDToken = RangerRazClient.maskParam((String)razDToken);
                    LOG.debug("RangerRazIdentityTransformer.getDelegationTokenFromUGI(): found DT=[{}]", (Object)maskedRazDToken);
                }
                break;
            }
        }
        catch (IOException excp) {
            RangerRazClientLogger.error((Logger)LOG, (String)"RangerRazIdentityTransformer.getDelegationTokenFromUGI(): failed", (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRazIdentityTransformer.getDelegationTokenFromUGI(): ret={}", maskedRazDToken);
        }
        return razDToken;
    }
}

