/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.presto.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.presto.client.PrestoClient;
import org.apache.ranger.services.presto.client.PrestoConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrestoResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(PrestoResourceManager.class);
    private static final String CATALOG = "catalog";
    private static final String SCHEMA = "schema";
    private static final String TABLE = "table";
    private static final String COLUMN = "column";

    private PrestoResourceManager() {
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) {
        Map<String, Object> ret;
        LOG.debug("==> PrestoResourceManager.connectionTest() ServiceName: {} Configs: {}", (Object)serviceName, configs);
        try {
            ret = PrestoClient.connectionTest(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error("<== PrestoResourceManager.connectionTest() Error: ", (Throwable)e);
            throw e;
        }
        LOG.debug("<== PrestoResourceManager.connectionTest() Result : {}", ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPrestoResources(String serviceName, String serviceType, Map<String, String> configs, ResourceLookupContext context) throws Exception {
        List resultList;
        block28: {
            String userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            resultList = null;
            List catalogList = null;
            List schemaList = null;
            List tableList = null;
            List columnList = null;
            String catalogName = null;
            String schemaName = null;
            String tableName = null;
            String columnName = null;
            LOG.debug("==> PrestoResourceMgr.getPrestoResources() UserInput: {}, resource: {}, resourceMap: {}", new Object[]{userInput, resource, resourceMap});
            if (userInput != null && resource != null) {
                if (resourceMap != null && !resourceMap.isEmpty()) {
                    catalogList = (List)resourceMap.get(CATALOG);
                    schemaList = (List)resourceMap.get(SCHEMA);
                    tableList = (List)resourceMap.get(TABLE);
                    columnList = (List)resourceMap.get(COLUMN);
                }
                switch (resource.trim().toLowerCase()) {
                    case "catalog": {
                        catalogName = userInput;
                        break;
                    }
                    case "schema": {
                        schemaName = userInput;
                        break;
                    }
                    case "table": {
                        tableName = userInput;
                        break;
                    }
                    case "column": {
                        columnName = userInput;
                        break;
                    }
                }
            }
            if (serviceName != null && userInput != null) {
                try {
                    LOG.debug("==> PrestoResourceManager.getPrestoResources() UserInput: {}, configs: {}, catalogList: {}, tableList: {}, columnList: {}", new Object[]{userInput, configs, catalogList, tableList, columnList});
                    PrestoClient prestoClient = new PrestoConnectionManager().getPrestoConnection(serviceName, serviceType, configs);
                    Callable<List> callableObj = null;
                    List finalCatalogList = catalogList;
                    List finalSchemaList = schemaList;
                    List finalTableList = tableList;
                    List finalColumnList = columnList;
                    if (prestoClient == null) break block28;
                    if (catalogName != null && !catalogName.isEmpty()) {
                        String finalCatalogName = catalogName;
                        callableObj = () -> prestoClient.getCatalogList(finalCatalogName, finalCatalogList);
                    } else if (schemaName != null && !schemaName.isEmpty()) {
                        String finalSchemaName = schemaName;
                        callableObj = () -> prestoClient.getSchemaList(finalSchemaName, finalCatalogList, finalSchemaList);
                    } else if (tableName != null && !tableName.isEmpty()) {
                        String finalTableName = tableName;
                        callableObj = () -> prestoClient.getTableList(finalTableName, finalCatalogList, finalSchemaList, finalTableList);
                    } else if (columnName != null && !columnName.isEmpty()) {
                        String finalColumnName = columnName = columnName + "*";
                        callableObj = () -> prestoClient.getColumnList(finalColumnName, finalCatalogList, finalSchemaList, finalTableList, finalColumnList);
                    }
                    if (callableObj != null) {
                        PrestoClient prestoClient2 = prestoClient;
                        synchronized (prestoClient2) {
                            resultList = (List)TimedEventUtil.timedTask(callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                            break block28;
                        }
                    }
                    LOG.error("Could not initiate a PrestoClient timedTask");
                }
                catch (Exception e) {
                    LOG.error("Unable to get Presto resource", (Throwable)e);
                    throw e;
                }
            }
        }
        return resultList;
    }
}

