/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.presto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.presto.client.PrestoResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServicePresto
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServicePresto.class);
    public static final String ACCESS_TYPE_SELECT = "select";

    public Map<String, Object> validateConfig() {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        LOG.debug("RangerServicePresto.validateConfig(): Service: {}", (Object)serviceName);
        if (this.configs != null) {
            try {
                if (!this.configs.containsKey("password")) {
                    this.configs.put("password", null);
                }
                ret = PrestoResourceManager.connectionTest(serviceName, this.configs);
            }
            catch (HadoopException he) {
                LOG.error("<== RangerServicePresto.validateConfig() Error: {}", (Object)String.valueOf((Object)he));
                throw he;
            }
        }
        LOG.debug("RangerServicePresto.validateConfig(): Response: {}", ret);
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        String serviceType = this.getServiceType();
        Map configs = this.getConfigs();
        LOG.debug("==> RangerServicePresto.lookupResource() Context: {}", (Object)context);
        if (context != null) {
            try {
                if (!configs.containsKey("password")) {
                    configs.put("password", null);
                }
                ret = PrestoResourceManager.getPrestoResources(serviceName, serviceType, configs, context);
            }
            catch (Exception e) {
                LOG.error("<==RangerServicePresto.lookupResource() Error : {}", (Object)String.valueOf(e));
                throw e;
            }
        }
        LOG.debug("<== RangerServicePresto.lookupResource() Response: {}", ret);
        return ret;
    }

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        LOG.debug("==> RangerServicePresto.getDefaultRangerPolicies()");
        List ret = super.getDefaultRangerPolicies();
        for (RangerPolicy defaultPolicy : ret) {
            if (!defaultPolicy.getName().contains("all") || !StringUtils.isNotBlank((String)this.lookUpUser)) continue;
            ArrayList<RangerPolicy.RangerPolicyItemAccess> accessListForLookupUser = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_SELECT));
            RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
            policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
            policyItemForLookupUser.setAccesses(accessListForLookupUser);
            policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
            defaultPolicy.addPolicyItem(policyItemForLookupUser);
        }
        LOG.debug("<== RangerServicePresto.getDefaultRangerPolicies()");
        return ret;
    }
}

