/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.presto.authorizer;

import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.CatalogSchemaRoutineName;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.spi.security.SystemSecurityContext;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.Type;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.ranger.authorization.presto.authorizer.RangerConfig;
import org.apache.ranger.plugin.classloader.PluginClassLoaderActivator;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;

public class RangerSystemAccessControl
implements SystemAccessControl {
    private static final String RANGER_PLUGIN_TYPE = "presto";
    private static final String RANGER_PRESTO_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.presto.authorizer.RangerSystemAccessControl";
    private final RangerPluginClassLoader pluginClassLoader;
    private final SystemAccessControl systemAccessControlImpl;

    @Inject
    public RangerSystemAccessControl(RangerConfig config) {
        try {
            this.pluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_PRESTO_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.pluginClassLoader);
            try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "RangerSystemAccessControl");){
                HashMap<String, String> configMap = new HashMap<String, String>();
                if (config.getKeytab() != null && config.getPrincipal() != null) {
                    configMap.put("ranger.keytab", config.getKeytab());
                    configMap.put("ranger.principal", config.getPrincipal());
                }
                configMap.put("ranger.use_ugi", Boolean.toString(config.isUseUgi()));
                if (config.getHadoopConfigPath() != null) {
                    configMap.put("ranger.hadoop_config", config.getHadoopConfigPath());
                }
                this.systemAccessControlImpl = (SystemAccessControl)cls.getDeclaredConstructor(Map.class).newInstance(configMap);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void checkCanImpersonateUser(SystemSecurityContext context, String userName) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanImpersonateUser");){
            this.systemAccessControlImpl.checkCanImpersonateUser(context, userName);
        }
    }

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanSetUser");){
            this.systemAccessControlImpl.checkCanSetUser(principal, userName);
        }
    }

    public void checkCanExecuteQuery(SystemSecurityContext context) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanExecuteQuery");){
            this.systemAccessControlImpl.checkCanExecuteQuery(context);
        }
    }

    public void checkCanViewQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanViewQueryOwnedBy");){
            this.systemAccessControlImpl.checkCanViewQueryOwnedBy(context, queryOwner);
        }
    }

    public Set<String> filterViewQueryOwnedBy(SystemSecurityContext context, Set<String> queryOwners) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "filterViewQueryOwnedBy");){
            Set set = this.systemAccessControlImpl.filterViewQueryOwnedBy(context, queryOwners);
            return set;
        }
    }

    public void checkCanKillQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanKillQueryOwnedBy");){
            this.systemAccessControlImpl.checkCanKillQueryOwnedBy(context, queryOwner);
        }
    }

    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanSetSystemSessionProperty");){
            this.systemAccessControlImpl.checkCanSetSystemSessionProperty(context, propertyName);
        }
    }

    public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanAccessCatalog");){
            this.systemAccessControlImpl.checkCanAccessCatalog(context, catalogName);
        }
    }

    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanAccessCatalog");){
            Set set = this.systemAccessControlImpl.filterCatalogs(context, catalogs);
            return set;
        }
    }

    public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanCreateSchema");){
            this.systemAccessControlImpl.checkCanCreateSchema(context, schema);
        }
    }

    public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanDropSchema");){
            this.systemAccessControlImpl.checkCanDropSchema(context, schema);
        }
    }

    public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanRenameSchema");){
            this.systemAccessControlImpl.checkCanRenameSchema(context, schema, newSchemaName);
        }
    }

    public void checkCanSetSchemaAuthorization(SystemSecurityContext context, CatalogSchemaName schema, PrestoPrincipal principal) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanSetSchemaAuthorization");){
            this.systemAccessControlImpl.checkCanSetSchemaAuthorization(context, schema, principal);
        }
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanShowSchemas");){
            this.systemAccessControlImpl.checkCanShowSchemas(context, catalogName);
        }
    }

    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "filterSchemas");){
            Set set = this.systemAccessControlImpl.filterSchemas(context, catalogName, schemaNames);
            return set;
        }
    }

    public void checkCanShowCreateSchema(SystemSecurityContext context, CatalogSchemaName schemaName) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanShowCreateSchema");){
            this.systemAccessControlImpl.checkCanShowCreateSchema(context, schemaName);
        }
    }

    public void checkCanShowCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanShowCreateTable");){
            this.systemAccessControlImpl.checkCanShowCreateTable(context, table);
        }
    }

    public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanCreateTable");){
            this.systemAccessControlImpl.checkCanCreateTable(context, table);
        }
    }

    public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanDropTable");){
            this.systemAccessControlImpl.checkCanDropTable(context, table);
        }
    }

    public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanRenameTable");){
            this.systemAccessControlImpl.checkCanRenameTable(context, table, newTable);
        }
    }

    public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanSetTableComment");){
            this.systemAccessControlImpl.checkCanSetTableComment(context, table);
        }
    }

    public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanShowTables");){
            this.systemAccessControlImpl.checkCanShowTables(context, schema);
        }
    }

    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "filterTables");){
            Set set = this.systemAccessControlImpl.filterTables(context, catalogName, tableNames);
            return set;
        }
    }

    public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName table) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanShowColumns");){
            this.systemAccessControlImpl.checkCanShowColumns(context, table);
        }
    }

    public List<ColumnMetadata> filterColumns(SystemSecurityContext context, CatalogSchemaTableName table, List<ColumnMetadata> columns) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "filterColumns");){
            List list = this.systemAccessControlImpl.filterColumns(context, table, columns);
            return list;
        }
    }

    public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanAddColumn");){
            this.systemAccessControlImpl.checkCanAddColumn(context, table);
        }
    }

    public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanDropColumn");){
            this.systemAccessControlImpl.checkCanDropColumn(context, table);
        }
    }

    public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanRenameColumn");){
            this.systemAccessControlImpl.checkCanRenameColumn(context, table);
        }
    }

    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanSelectFromColumns");){
            this.systemAccessControlImpl.checkCanSelectFromColumns(context, table, columns);
        }
    }

    public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanInsertIntoTable");){
            this.systemAccessControlImpl.checkCanInsertIntoTable(context, table);
        }
    }

    public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanDeleteFromTable");){
            this.systemAccessControlImpl.checkCanDeleteFromTable(context, table);
        }
    }

    public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanCreateView");){
            this.systemAccessControlImpl.checkCanCreateView(context, view);
        }
    }

    public void checkCanRenameView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanRenameView");){
            this.systemAccessControlImpl.checkCanRenameView(context, view, newView);
        }
    }

    public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanDropView");){
            this.systemAccessControlImpl.checkCanDropView(context, view);
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanCreateViewWithSelectFromColumns");){
            this.systemAccessControlImpl.checkCanCreateViewWithSelectFromColumns(context, table, columns);
        }
    }

    public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, String functionName, PrestoPrincipal grantee, boolean grantOption) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanGrantExecuteFunctionPrivilege");){
            this.systemAccessControlImpl.checkCanGrantExecuteFunctionPrivilege(context, functionName, grantee, grantOption);
        }
    }

    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanSetCatalogSessionProperty");){
            this.systemAccessControlImpl.checkCanSetCatalogSessionProperty(context, catalogName, propertyName);
        }
    }

    public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal grantee, boolean withGrantOption) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanGrantTablePrivilege");){
            this.systemAccessControlImpl.checkCanGrantTablePrivilege(context, privilege, table, grantee, withGrantOption);
        }
    }

    public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal revokee, boolean grantOptionFor) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanRevokeTablePrivilege");){
            this.systemAccessControlImpl.checkCanRevokeTablePrivilege(context, privilege, table, revokee, grantOptionFor);
        }
    }

    public void checkCanShowRoles(SystemSecurityContext context, String catalogName) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanShowRoles");){
            this.systemAccessControlImpl.checkCanShowRoles(context, catalogName);
        }
    }

    public void checkCanExecuteProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName procedure) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanExecuteProcedure");){
            this.systemAccessControlImpl.checkCanExecuteProcedure(systemSecurityContext, procedure);
        }
    }

    public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, String functionName) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkCanExecuteFunction");){
            this.systemAccessControlImpl.checkCanExecuteFunction(systemSecurityContext, functionName);
        }
    }

    public Optional<ViewExpression> getRowFilter(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "getRowFilter");){
            Optional optional = this.systemAccessControlImpl.getRowFilter(context, tableName);
            return optional;
        }
    }

    public Optional<ViewExpression> getColumnMask(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "getRowFilter");){
            Optional optional = this.systemAccessControlImpl.getColumnMask(context, tableName, columnName, type);
            return optional;
        }
    }
}

