/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.utils;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RangerCredentialProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerCredentialProvider.class);
    private static final RangerCredentialProvider CRED_PROVIDER = new RangerCredentialProvider();

    RangerCredentialProvider() {
    }

    public static RangerCredentialProvider getInstance() {
        return CRED_PROVIDER;
    }

    public String getCredentialString(String url, String alias) {
        List<CredentialProvider> providers;
        if (url != null && alias != null && (providers = this.getCredentialProviders(url)) != null) {
            for (CredentialProvider provider : providers) {
                try {
                    CredentialProvider.CredentialEntry credEntry = provider.getCredentialEntry(alias);
                    if (credEntry == null || credEntry.getCredential() == null) continue;
                    return new String(credEntry.getCredential());
                }
                catch (Exception ie) {
                    LOG.error("Unable to get the Credential Provider from the Configuration", (Throwable)ie);
                }
            }
        }
        return null;
    }

    List<CredentialProvider> getCredentialProviders(String url) {
        if (url != null) {
            try {
                Configuration conf = new Configuration();
                conf.set("hadoop.security.credential.provider.path", url);
                return CredentialProviderFactory.getProviders((Configuration)conf);
            }
            catch (Exception ie) {
                LOG.error("Unable to get the Credential Provider from the Configuration", (Throwable)ie);
            }
        }
        return null;
    }
}

