/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.credutils;

import java.math.BigDecimal;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.ranger.authorization.credutils.kerberos.KerberosCredentialsProvider;
import org.apache.ranger.authorization.credutils.kerberos.KeytabJaasConf;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialsProviderUtil {
    private static final Logger logger = LoggerFactory.getLogger(CredentialsProviderUtil.class);
    private static final Oid SPNEGO_OID = CredentialsProviderUtil.getSpnegoOid();
    private static final String CRED_CONF_NAME = "ESClientLoginConf";
    public static long ticketExpireTime80;

    private CredentialsProviderUtil() {
    }

    public static KerberosCredentialsProvider getKerberosCredentials(String user, String password) {
        KerberosCredentialsProvider credentialsProvider = new KerberosCredentialsProvider();
        GSSManager gssManager = GSSManager.getInstance();
        try {
            GSSName gssUserPrincipalName = gssManager.createName(user, GSSName.NT_USER_NAME);
            Subject subject = CredentialsProviderUtil.login(user, password);
            AccessControlContext acc = AccessController.getContext();
            GSSCredential credential = CredentialsProviderUtil.doAsPrivilegedWrapper(subject, () -> gssManager.createCredential(gssUserPrincipalName, 0, SPNEGO_OID, 1), acc);
            credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Negotiate"), (Credentials)new KerberosCredentials(credential));
        }
        catch (GSSException e) {
            logger.error("GSSException:", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (PrivilegedActionException e) {
            logger.error("PrivilegedActionException:", (Throwable)e);
            throw new RuntimeException(e);
        }
        return credentialsProvider;
    }

    public static synchronized KerberosTicket getTGT(Subject subject) {
        Set<KerberosTicket> tickets = subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            if (!server.getName().equals("krbtgt/" + server.getRealm() + "@" + server.getRealm())) continue;
            logger.debug("Client principal is \"{}\".", (Object)ticket.getClient().getName());
            logger.debug("Server principal is \"{}\".", (Object)ticket.getServer().getName());
            return ticket;
        }
        return null;
    }

    public static Boolean ticketWillExpire(KerberosTicket ticket) {
        long ticketExpireTime = ticket.getEndTime().getTime();
        long currrentTime = new Date().getTime();
        logger.debug("TicketExpireTime is:{}", (Object)ticketExpireTime);
        logger.debug("currrentTime is:{}", (Object)currrentTime);
        if (ticketExpireTime80 == 0L) {
            long timeDiff = ticketExpireTime - currrentTime;
            long timeDiff20 = Math.round(Float.parseFloat(BigDecimal.valueOf((double)timeDiff * 0.2).toPlainString()));
            ticketExpireTime80 = ticketExpireTime - timeDiff20;
        }
        logger.debug("ticketExpireTime80 is:{}", (Object)ticketExpireTime80);
        if (currrentTime > ticketExpireTime80) {
            logger.debug("Current time is more than 80% of Ticket Expire Time!!");
            ticketExpireTime80 = 0L;
            return true;
        }
        return false;
    }

    public static synchronized Subject login(String userPrincipalName, String keytabPath) throws PrivilegedActionException {
        return AccessController.doPrivileged(() -> {
            Subject subject = new Subject(false, Collections.singleton(new KerberosPrincipal(userPrincipalName)), Collections.emptySet(), Collections.emptySet());
            KeytabJaasConf conf = new KeytabJaasConf(userPrincipalName, keytabPath, false);
            LoginContext loginContext = new LoginContext(CRED_CONF_NAME, subject, null, conf);
            loginContext.login();
            return loginContext.getSubject();
        });
    }

    public static CredentialsProvider getBasicCredentials(String user, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        return credentialsProvider;
    }

    static <T> T doAsPrivilegedWrapper(Subject subject, PrivilegedExceptionAction<T> action, AccessControlContext acc) throws PrivilegedActionException {
        try {
            return (T)AccessController.doPrivileged(() -> Subject.doAsPrivileged(subject, action, acc));
        }
        catch (PrivilegedActionException pae) {
            if (pae.getCause() instanceof PrivilegedActionException) {
                throw (PrivilegedActionException)pae.getCause();
            }
            throw pae;
        }
    }

    private static Oid getSpnegoOid() {
        Oid oid;
        try {
            oid = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException gsse) {
            throw new RuntimeException(gsse);
        }
        return oid;
    }
}

