/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.util.RangerUserStore;

public class RangerUserStoreUtil {
    public static final String CLOUD_IDENTITY_NAME = "cloud_id";
    private final RangerUserStore userStore;
    private final long userStoreVersion;
    private final Map<String, Set<String>> userGroups;
    private final Map<String, Map<String, String>> userAttributes;
    private final Map<String, Map<String, String>> groupAttributes;
    private volatile Map<String, String> userEmailToName;

    public RangerUserStoreUtil(RangerUserStore userStore) {
        this.userStore = userStore;
        if (userStore != null) {
            this.userStoreVersion = userStore.getUserStoreVersion() != null ? userStore.getUserStoreVersion() : -1L;
            this.userGroups = userStore.getUserGroupMapping() != null ? userStore.getUserGroupMapping() : Collections.emptyMap();
            this.userAttributes = userStore.getUserAttrMapping() != null ? userStore.getUserAttrMapping() : Collections.emptyMap();
            this.groupAttributes = userStore.getGroupAttrMapping() != null ? userStore.getGroupAttrMapping() : Collections.emptyMap();
        } else {
            this.userStoreVersion = -1L;
            this.userGroups = Collections.emptyMap();
            this.userAttributes = Collections.emptyMap();
            this.groupAttributes = Collections.emptyMap();
            this.userEmailToName = Collections.emptyMap();
        }
    }

    public static String getPrintableOptions(Map<String, String> otherAttributes) {
        if (MapUtils.isEmpty(otherAttributes)) {
            return "{}";
        }
        StringBuilder ret = new StringBuilder("{");
        for (Map.Entry<String, String> entry : otherAttributes.entrySet()) {
            ret.append(entry.getKey()).append(", ").append("[").append(entry.getValue()).append("]").append(",");
        }
        ret.append("}");
        return ret.toString();
    }

    public static String getAttrVal(Map<String, Map<String, String>> attrMap, String name, String attrName) {
        Map<String, String> attrs;
        String ret = null;
        if (StringUtils.isNotEmpty((String)name) && StringUtils.isNotEmpty((String)attrName) && MapUtils.isNotEmpty(attrs = attrMap.get(name))) {
            ret = attrs.get(attrName);
        }
        return ret;
    }

    public RangerUserStore getUserStore() {
        return this.userStore;
    }

    public long getUserStoreVersion() {
        return this.userStoreVersion;
    }

    public Set<String> getUserGroups(String userName) {
        return this.userGroups.get(userName);
    }

    public Map<String, String> getUserAttributes(String userName) {
        return this.userAttributes.get(userName);
    }

    public Map<String, String> getGroupAttributes(String groupName) {
        return this.groupAttributes.get(groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserNameFromEmail(String emailAddress) {
        Map<String, String> userEmailToName = this.userEmailToName;
        if (userEmailToName == null) {
            RangerUserStoreUtil rangerUserStoreUtil = this;
            synchronized (rangerUserStoreUtil) {
                userEmailToName = this.userEmailToName;
                if (userEmailToName == null) {
                    userEmailToName = this.userEmailToName = this.buildUserEmailToNameMap();
                }
            }
        }
        return userEmailToName != null ? userEmailToName.get(emailAddress) : null;
    }

    public String getCloudId(Map<String, Map<String, String>> attrMap, String name) {
        return RangerUserStoreUtil.getAttrVal(attrMap, name, CLOUD_IDENTITY_NAME);
    }

    private Map<String, String> buildUserEmailToNameMap() {
        Map<String, String> ret;
        if (!this.userAttributes.isEmpty()) {
            ret = new HashMap();
            for (Map.Entry<String, Map<String, String>> entry : this.userAttributes.entrySet()) {
                String userName = entry.getKey();
                Map<String, String> userAttrs = entry.getValue();
                String emailAddr = userAttrs != null ? userAttrs.get("_emailAddress") : null;
                if (!StringUtils.isNotBlank((String)emailAddr)) continue;
                ret.put(emailAddr, userName);
            }
        } else {
            ret = Collections.emptyMap();
        }
        return ret;
    }
}

